/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.util.Preconditions;

@Internal
public class TaskManagerJobMetricGroup
extends JobMetricGroup<TaskManagerMetricGroup> {
    private final Map<ExecutionAttemptID, TaskMetricGroup> tasks = new HashMap<ExecutionAttemptID, TaskMetricGroup>();

    public TaskManagerJobMetricGroup(MetricRegistry registry, TaskManagerMetricGroup parent, JobID jobId, @Nullable String jobName) {
        super(registry, parent, jobId, jobName, registry.getScopeFormats().getTaskManagerJobFormat().formatScope(Preconditions.checkNotNull(parent), jobId, jobName));
    }

    public final TaskManagerMetricGroup parent() {
        return (TaskManagerMetricGroup)this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskMetricGroup addTask(ExecutionAttemptID executionAttemptID, String taskName) {
        Preconditions.checkNotNull(executionAttemptID);
        Preconditions.checkNotNull(taskName);
        TaskManagerJobMetricGroup taskManagerJobMetricGroup = this;
        synchronized (taskManagerJobMetricGroup) {
            if (!this.isClosed()) {
                TaskMetricGroup prior = this.tasks.get(executionAttemptID);
                if (prior != null) {
                    return prior;
                }
                TaskMetricGroup task = new TaskMetricGroup(this.registry, this, executionAttemptID, taskName);
                this.tasks.put(executionAttemptID, task);
                return task;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskMetricGroup(ExecutionAttemptID executionId) {
        Preconditions.checkNotNull(executionId);
        TaskManagerJobMetricGroup taskManagerJobMetricGroup = this;
        synchronized (taskManagerJobMetricGroup) {
            if (!this.isClosed()) {
                this.tasks.remove(executionId);
            }
        }
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup<?>> subComponents() {
        Preconditions.checkState(Thread.holdsLock(this));
        return this.tasks.values();
    }
}

