/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.SourceSplitMetricGroup;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class InternalSourceSplitMetricGroup
extends ProxyMetricGroup<MetricGroup>
implements SourceSplitMetricGroup {
    static final Logger LOG = LoggerFactory.getLogger(InternalSourceSplitMetricGroup.class);
    private final TimerGauge pausedTimePerSecond;
    private final TimerGauge idleTimePerSecond;
    private final Gauge<Long> currentWatermarkGauge;
    private final Clock clock;
    private static final String SPLIT = "split";
    private static final String WATERMARK = "watermark";
    private static final long SPLIT_NOT_STARTED = -1L;
    private long splitStartTime = -1L;
    private final MetricGroup splitWatermarkMetricGroup;

    private InternalSourceSplitMetricGroup(MetricGroup parentMetricGroup, Clock clock, String splitId, Gauge<Long> currentWatermark) {
        super(parentMetricGroup);
        this.clock = clock;
        this.splitWatermarkMetricGroup = parentMetricGroup.addGroup(SPLIT, splitId).addGroup(WATERMARK);
        this.pausedTimePerSecond = (TimerGauge)this.splitWatermarkMetricGroup.gauge("pausedTimeMsPerSecond", (Gauge)new TimerGauge(clock));
        this.idleTimePerSecond = (TimerGauge)this.splitWatermarkMetricGroup.gauge("idleTimeMsPerSecond", (Gauge)new TimerGauge(clock));
        this.splitWatermarkMetricGroup.gauge("activeTimeMsPerSecond", this::getActiveTimePerSecond);
        this.splitWatermarkMetricGroup.gauge("accumulatedPausedTimeMs", this::getAccumulatedPausedTime);
        this.splitWatermarkMetricGroup.gauge("accumulatedActiveTimeMs", this::getAccumulatedActiveTime);
        this.splitWatermarkMetricGroup.gauge("accumulatedIdleTimeMs", this::getAccumulatedIdleTime);
        this.currentWatermarkGauge = this.splitWatermarkMetricGroup.gauge("currentWatermark", currentWatermark);
    }

    public static InternalSourceSplitMetricGroup wrap(OperatorMetricGroup operatorMetricGroup, String splitId, Gauge<Long> currentWatermark) {
        return new InternalSourceSplitMetricGroup((MetricGroup)operatorMetricGroup, SystemClock.getInstance(), splitId, currentWatermark);
    }

    @VisibleForTesting
    public static InternalSourceSplitMetricGroup mock(MetricGroup metricGroup, String splitId, Gauge<Long> currentWatermark) {
        return new InternalSourceSplitMetricGroup(metricGroup, SystemClock.getInstance(), splitId, currentWatermark);
    }

    @VisibleForTesting
    public static InternalSourceSplitMetricGroup wrap(OperatorMetricGroup operatorMetricGroup, Clock clock, String splitId, Gauge<Long> currentWatermark) {
        return new InternalSourceSplitMetricGroup((MetricGroup)operatorMetricGroup, clock, splitId, currentWatermark);
    }

    public void markSplitStart() {
        this.splitStartTime = this.clock.absoluteTimeMillis();
    }

    public void maybeMarkSplitStart() {
        if (this.splitStartTime == -1L) {
            this.markSplitStart();
        }
    }

    public long getCurrentWatermark() {
        return (Long)this.currentWatermarkGauge.getValue();
    }

    public void markPaused() {
        this.maybeMarkSplitStart();
        if (this.isIdle().booleanValue()) {
            this.markNotIdle();
            LOG.warn("Split marked paused while still idle");
        }
        this.pausedTimePerSecond.markStart();
    }

    public void markIdle() {
        this.maybeMarkSplitStart();
        if (this.isPaused().booleanValue()) {
            this.markNotPaused();
            LOG.warn("Split marked idle while still paused");
        }
        this.idleTimePerSecond.markStart();
    }

    public void markNotPaused() {
        this.maybeMarkSplitStart();
        this.pausedTimePerSecond.markEnd();
    }

    public void markNotIdle() {
        this.maybeMarkSplitStart();
        this.idleTimePerSecond.markEnd();
    }

    public double getActiveTimePerSecond() {
        if (this.splitStartTime == -1L) {
            return 0.0;
        }
        double activeTimePerSecond = 1000.0 - (double)this.getPausedTimePerSecond() - (double)this.getIdleTimePerSecond();
        return Math.max(activeTimePerSecond, 0.0);
    }

    public double getAccumulatedActiveTime() {
        if (this.splitStartTime == -1L) {
            return 0.0;
        }
        return Math.max(this.clock.absoluteTimeMillis() - this.splitStartTime - this.getAccumulatedPausedTime() - this.getAccumulatedIdleTime(), 0L);
    }

    public long getAccumulatedIdleTime() {
        return this.idleTimePerSecond.getAccumulatedCount();
    }

    public long getIdleTimePerSecond() {
        return this.idleTimePerSecond.getValue();
    }

    public long getPausedTimePerSecond() {
        return this.pausedTimePerSecond.getValue();
    }

    public long getAccumulatedPausedTime() {
        return this.pausedTimePerSecond.getAccumulatedCount();
    }

    public Boolean isPaused() {
        return this.pausedTimePerSecond.isMeasuring();
    }

    public Boolean isIdle() {
        return this.idleTimePerSecond.isMeasuring();
    }

    public Boolean isActive() {
        return this.isPaused() == false && this.isIdle() == false;
    }

    public void onSplitFinished() {
        if (this.splitWatermarkMetricGroup instanceof AbstractMetricGroup) {
            ((AbstractMetricGroup)this.splitWatermarkMetricGroup).close();
        } else if (this.splitWatermarkMetricGroup != null) {
            LOG.warn("Split watermark metric group can not be closed, expecting an instance of AbstractMetricGroup but got: ", (Object)this.splitWatermarkMetricGroup.getClass().getName());
        }
    }

    @VisibleForTesting
    public MetricGroup getSplitWatermarkMetricGroup() {
        return this.splitWatermarkMetricGroup;
    }
}

