/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.program.MutatedConfigurationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.execution.DetachedJobExecutionResult;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.JobListener;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.runtime.dispatcher.ConfigurationNotAllowedMessage;
import org.apache.flink.shaded.guava33.com.google.common.collect.MapDifference;
import org.apache.flink.shaded.guava33.com.google.common.collect.Maps;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class StreamContextEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(StreamContextEnvironment.class);
    private final boolean suppressSysout;
    private final boolean enforceSingleJobExecution;
    private final Configuration clusterConfiguration;
    private int jobCounter;
    private final boolean programConfigEnabled;
    private final Collection<String> programConfigWildcards;

    public StreamContextEnvironment(PipelineExecutorServiceLoader executorServiceLoader, Configuration configuration, ClassLoader userCodeClassLoader, boolean enforceSingleJobExecution, boolean suppressSysout) {
        this(executorServiceLoader, configuration, configuration, userCodeClassLoader, enforceSingleJobExecution, suppressSysout, true, Collections.emptyList());
    }

    @Internal
    public StreamContextEnvironment(PipelineExecutorServiceLoader executorServiceLoader, Configuration clusterConfiguration, Configuration configuration, ClassLoader userCodeClassLoader, boolean enforceSingleJobExecution, boolean suppressSysout, boolean programConfigEnabled, Collection<String> programConfigWildcards) {
        super(executorServiceLoader, configuration, userCodeClassLoader);
        this.suppressSysout = suppressSysout;
        this.enforceSingleJobExecution = enforceSingleJobExecution;
        this.clusterConfiguration = clusterConfiguration;
        this.jobCounter = 0;
        this.programConfigEnabled = programConfigEnabled;
        this.programConfigWildcards = programConfigWildcards;
    }

    @Override
    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        JobClient jobClient = this.executeAsync(streamGraph);
        List<JobListener> jobListeners = this.getJobListeners();
        try {
            JobExecutionResult jobExecutionResult = this.getJobExecutionResult(jobClient);
            jobListeners.forEach(jobListener -> jobListener.onJobExecuted(jobExecutionResult, null));
            return jobExecutionResult;
        }
        catch (Throwable t) {
            jobListeners.forEach(jobListener -> jobListener.onJobExecuted(null, ExceptionUtils.stripExecutionException(t)));
            ExceptionUtils.rethrowException(t);
            return null;
        }
    }

    private JobExecutionResult getJobExecutionResult(JobClient jobClient) throws Exception {
        JobExecutionResult jobExecutionResult;
        Preconditions.checkNotNull(jobClient);
        if (this.configuration.get(DeploymentOptions.ATTACHED).booleanValue()) {
            CompletableFuture<JobExecutionResult> jobExecutionResultFuture = jobClient.getJobExecutionResult();
            ExecutorService clientHeartbeatService = null;
            if (this.configuration.get(DeploymentOptions.SHUTDOWN_IF_ATTACHED).booleanValue()) {
                Thread shutdownHook = ShutdownHookUtil.addShutdownHook(() -> jobClient.cancel().get(1L, TimeUnit.SECONDS), StreamContextEnvironment.class.getSimpleName(), LOG);
                jobExecutionResultFuture.whenComplete((ignored, throwable) -> ShutdownHookUtil.removeShutdownHook(shutdownHook, StreamContextEnvironment.class.getSimpleName(), LOG));
                clientHeartbeatService = ClientUtils.reportHeartbeatPeriodically(jobClient, this.configuration.get(ClientOptions.CLIENT_HEARTBEAT_INTERVAL).toMillis(), this.configuration.get(ClientOptions.CLIENT_HEARTBEAT_TIMEOUT).toMillis());
            }
            jobExecutionResult = jobExecutionResultFuture.get();
            if (clientHeartbeatService != null) {
                clientHeartbeatService.shutdown();
            }
            if (!this.suppressSysout) {
                System.out.println(jobExecutionResult);
            }
        } else {
            jobExecutionResult = new DetachedJobExecutionResult(jobClient.getJobID());
        }
        return jobExecutionResult;
    }

    @Override
    public JobClient executeAsync(StreamGraph streamGraph) throws Exception {
        this.checkNotAllowedConfigurations();
        this.validateAllowedExecution();
        JobClient jobClient = super.executeAsync(streamGraph);
        if (!this.suppressSysout) {
            System.out.println("Job has been submitted with JobID " + String.valueOf(jobClient.getJobID()));
        }
        return jobClient;
    }

    private void validateAllowedExecution() {
        if (this.enforceSingleJobExecution && this.jobCounter > 0) {
            throw new FlinkRuntimeException("Cannot have more than one execute() or executeAsync() call in a single environment.");
        }
        ++this.jobCounter;
    }

    public static void setAsContext(PipelineExecutorServiceLoader executorServiceLoader, Configuration clusterConfiguration, ClassLoader userCodeClassLoader, boolean enforceSingleJobExecution, boolean suppressSysout) {
        StreamExecutionEnvironmentFactory factory = envInitConfig -> {
            boolean programConfigEnabled = clusterConfiguration.get(DeploymentOptions.PROGRAM_CONFIG_ENABLED);
            List<String> programConfigWildcards = clusterConfiguration.get(DeploymentOptions.PROGRAM_CONFIG_WILDCARDS);
            Configuration mergedEnvConfig = new Configuration();
            mergedEnvConfig.addAll(clusterConfiguration);
            mergedEnvConfig.addAll(envInitConfig);
            return new StreamContextEnvironment(executorServiceLoader, clusterConfiguration, mergedEnvConfig, userCodeClassLoader, enforceSingleJobExecution, suppressSysout, programConfigEnabled, programConfigWildcards);
        };
        StreamContextEnvironment.initializeContextEnvironment(factory);
    }

    public static void unsetAsContext() {
        StreamContextEnvironment.resetContextEnvironment();
    }

    private void checkNotAllowedConfigurations() throws MutatedConfigurationException {
        Collection<String> errorMessages = this.collectNotAllowedConfigurations();
        if (!errorMessages.isEmpty()) {
            throw new MutatedConfigurationException(errorMessages);
        }
    }

    private Collection<String> collectNotAllowedConfigurations() {
        if (this.programConfigEnabled) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        Configuration clusterConfigMap = new Configuration(this.clusterConfiguration);
        this.removeProgramConfigWildcards(clusterConfigMap);
        this.checkMainConfiguration(clusterConfigMap, errors);
        return errors;
    }

    private void checkMainConfiguration(Configuration clusterConfigMap, List<String> errors) {
        Configuration envConfigMap = new Configuration(this.configuration);
        this.removeProgramConfigWildcards(envConfigMap);
        MapDifference<String, String> diff = Maps.difference(clusterConfigMap.toMap(), envConfigMap.toMap());
        diff.entriesOnlyOnRight().forEach((k, v) -> errors.add(ConfigurationNotAllowedMessage.ofConfigurationAdded(k, v)));
        diff.entriesOnlyOnLeft().forEach((k, v) -> errors.add(ConfigurationNotAllowedMessage.ofConfigurationRemoved(k, v)));
        diff.entriesDiffering().forEach((k, v) -> errors.add(ConfigurationNotAllowedMessage.ofConfigurationChanged(k, v)));
    }

    private void checkConfigurationObject(Configuration expectedConfiguration, Configuration actualConfiguration, String configurationObjectName, List<String> errors) {
        this.removeProgramConfigWildcards(actualConfiguration);
        MapDifference<String, String> diff = Maps.difference(expectedConfiguration.toMap(), actualConfiguration.toMap());
        diff.entriesOnlyOnRight().forEach((k, v) -> errors.add(ConfigurationNotAllowedMessage.ofConfigurationObjectAdded(configurationObjectName, k, v)));
        diff.entriesDiffering().forEach((k, v) -> errors.add(ConfigurationNotAllowedMessage.ofConfigurationObjectChanged(configurationObjectName, k, v)));
        diff.entriesOnlyOnLeft().forEach((k, v) -> errors.add(ConfigurationNotAllowedMessage.ofConfigurationObjectRemoved(configurationObjectName, k, v)));
    }

    private void removeProgramConfigWildcards(Configuration mutableConfig) {
        for (String key : this.programConfigWildcards) {
            mutableConfig.removeKey(key);
        }
    }
}

