/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import org.apache.flink.annotation.Internal;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.jobmanager.JobManagerProcessUtils;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractContainerizedClusterClientFactory<ClusterID>
implements ClusterClientFactory<ClusterID> {
    @Override
    public ClusterSpecification getClusterSpecification(Configuration configuration) {
        Preconditions.checkNotNull(configuration);
        int jobManagerMemoryMB = JobManagerProcessUtils.processSpecFromConfig(configuration).getTotalProcessMemorySize().getMebiBytes();
        int taskManagerMemoryMB = TaskExecutorProcessUtils.processSpecFromConfig(configuration).getTotalProcessMemorySize().getMebiBytes();
        int slotsPerTaskManager = configuration.get(TaskManagerOptions.NUM_TASK_SLOTS);
        return new ClusterSpecification.ClusterSpecificationBuilder().setMasterMemoryMB(jobManagerMemoryMB).setTaskManagerMemoryMB(taskManagerMemoryMB).setSlotsPerTaskManager(slotsPerTaskManager).createClusterSpecification();
    }
}

