/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.FirstAttemptInitializationContext;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.types.Nothing;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Visitor;

@Internal
public class GenericDataSinkBase<IN>
extends Operator<Nothing> {
    protected final UserCodeWrapper<? extends OutputFormat<IN>> formatWrapper;
    protected Operator<IN> input = null;
    private Ordering localOrdering;

    public GenericDataSinkBase(OutputFormat<IN> f, UnaryOperatorInformation<IN, Nothing> operatorInfo, String name) {
        super(operatorInfo, name);
        Preconditions.checkNotNull(f, "The OutputFormat may not be null.");
        this.formatWrapper = new UserCodeObjectWrapper<OutputFormat<IN>>(f);
    }

    public GenericDataSinkBase(UserCodeWrapper<? extends OutputFormat<IN>> f, UnaryOperatorInformation<IN, Nothing> operatorInfo, String name) {
        super(operatorInfo, name);
        this.formatWrapper = Preconditions.checkNotNull(f, "The OutputFormat class may not be null.");
    }

    public Operator<IN> getInput() {
        return this.input;
    }

    public void setInput(Operator<IN> input) {
        this.input = Preconditions.checkNotNull(input, "The input may not be null.");
    }

    public Ordering getLocalOrder() {
        return this.localOrdering;
    }

    public void setLocalOrder(Ordering localOrder) {
        this.localOrdering = localOrder;
    }

    public UserCodeWrapper<? extends OutputFormat<IN>> getFormatWrapper() {
        return this.formatWrapper;
    }

    @Override
    public UserCodeWrapper<? extends OutputFormat<IN>> getUserCodeWrapper() {
        return this.formatWrapper;
    }

    @Override
    public void accept(Visitor<Operator<?>> visitor) {
        boolean descend = visitor.preVisit(this);
        if (descend) {
            this.input.accept(visitor);
            visitor.postVisit(this);
        }
    }

    protected void executeOnCollections(List<IN> inputData, RuntimeContext ctx, ExecutionConfig executionConfig) throws Exception {
        OutputFormat<IN> format = this.formatWrapper.getUserCodeObject();
        TypeInformation<IN> inputType = this.getInput().getOperatorInfo().getOutputType();
        if (this.localOrdering != null) {
            TypeComparator sortComparator;
            int[] sortColumns = this.localOrdering.getFieldPositions();
            boolean[] sortOrderings = this.localOrdering.getFieldSortDirections();
            if (inputType instanceof CompositeType) {
                sortComparator = ((CompositeType)inputType).createComparator(sortColumns, sortOrderings, 0, executionConfig);
            } else if (inputType instanceof AtomicType) {
                sortComparator = ((AtomicType)((Object)inputType)).createComparator(sortOrderings[0], executionConfig);
            } else {
                throw new UnsupportedOperationException("Local output sorting does not support type " + String.valueOf(inputType) + " yet.");
            }
            Collections.sort(inputData, new Comparator<IN>(){

                @Override
                public int compare(IN o1, IN o2) {
                    return sortComparator.compare(o1, o2);
                }
            });
        }
        if (format instanceof InitializeOnMaster) {
            ((InitializeOnMaster)((Object)format)).initializeGlobal(1);
        }
        format.configure(this.parameters);
        if (format instanceof RichOutputFormat) {
            ((RichOutputFormat)format).setRuntimeContext(ctx);
        }
        format.open(FirstAttemptInitializationContext.of(0, 1));
        for (IN element : inputData) {
            format.writeRecord(element);
        }
        format.close();
        if (format instanceof FinalizeOnMaster) {
            ((FinalizeOnMaster)((Object)format)).finalizeGlobal(new FinalizeOnMaster.FinalizationContext(){

                @Override
                public int getParallelism() {
                    return 1;
                }

                @Override
                public int getFinishedAttempt(int subtaskIndex) {
                    return 0;
                }
            });
        }
    }

    @Override
    public String toString() {
        return this.name;
    }
}

