/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkOutputMultiplexer;
import org.apache.flink.util.Preconditions;

@Internal
final class CombinedWatermarkStatus {
    private final List<PartialWatermark> partialWatermarks = new ArrayList<PartialWatermark>();
    private long combinedWatermark = Long.MIN_VALUE;
    private boolean idle = false;

    CombinedWatermarkStatus() {
    }

    public long getCombinedWatermark() {
        return this.combinedWatermark;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public boolean remove(PartialWatermark o) {
        return this.partialWatermarks.remove(o);
    }

    public void add(PartialWatermark element) {
        this.partialWatermarks.add(element);
    }

    public boolean updateCombinedWatermark() {
        long minimumOverAllOutputs = Long.MAX_VALUE;
        if (this.partialWatermarks.isEmpty()) {
            return false;
        }
        boolean allIdle = true;
        for (PartialWatermark partialWatermark : this.partialWatermarks) {
            if (partialWatermark.isIdle()) continue;
            minimumOverAllOutputs = Math.min(minimumOverAllOutputs, partialWatermark.getWatermark());
            allIdle = false;
        }
        this.idle = allIdle;
        if (!allIdle && minimumOverAllOutputs > this.combinedWatermark) {
            this.combinedWatermark = minimumOverAllOutputs;
            return true;
        }
        return false;
    }

    static class PartialWatermark {
        private long watermark = Long.MIN_VALUE;
        private boolean idle = false;
        private final WatermarkOutputMultiplexer.WatermarkUpdateListener onWatermarkUpdate;

        public PartialWatermark(WatermarkOutputMultiplexer.WatermarkUpdateListener onWatermarkUpdate) {
            this.onWatermarkUpdate = onWatermarkUpdate;
        }

        private long getWatermark() {
            Preconditions.checkState(!this.idle, "Output is idle.");
            return this.watermark;
        }

        public boolean setWatermark(long watermark) {
            boolean updated;
            this.setIdle(false);
            boolean bl = updated = watermark > this.watermark;
            if (updated) {
                this.onWatermarkUpdate.onWatermarkUpdate(watermark);
                this.watermark = Math.max(watermark, this.watermark);
            }
            return updated;
        }

        private boolean isIdle() {
            return this.idle;
        }

        public void setIdle(boolean idle) {
            this.idle = idle;
            this.onWatermarkUpdate.onIdleUpdate(idle);
        }
    }
}

