/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.variant;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.variant.BinaryVariantBuilder;
import org.apache.flink.types.variant.VariantBuilder;
import org.apache.flink.types.variant.VariantTypeException;

@PublicEvolving
public interface Variant {
    public boolean isPrimitive();

    public boolean isArray();

    public boolean isObject();

    public boolean isNull();

    public Type getType();

    public boolean getBoolean() throws VariantTypeException;

    public byte getByte() throws VariantTypeException;

    public short getShort() throws VariantTypeException;

    public int getInt() throws VariantTypeException;

    public long getLong() throws VariantTypeException;

    public float getFloat() throws VariantTypeException;

    public BigDecimal getDecimal() throws VariantTypeException;

    public double getDouble() throws VariantTypeException;

    public String getString() throws VariantTypeException;

    public LocalDate getDate() throws VariantTypeException;

    public LocalDateTime getDateTime() throws VariantTypeException;

    public Instant getInstant() throws VariantTypeException;

    public byte[] getBytes() throws VariantTypeException;

    public Object get() throws VariantTypeException;

    public <T> T getAs() throws VariantTypeException;

    public Variant getElement(int var1) throws VariantTypeException;

    public Variant getField(String var1) throws VariantTypeException;

    public String toJson();

    public static VariantBuilder newBuilder() {
        return new BinaryVariantBuilder();
    }

    @PublicEvolving
    public static enum Type {
        OBJECT,
        ARRAY,
        NULL,
        BOOLEAN,
        TINYINT,
        SMALLINT,
        INT,
        BIGINT,
        FLOAT,
        DOUBLE,
        DECIMAL,
        STRING,
        DATE,
        TIMESTAMP,
        TIMESTAMP_LTZ,
        BYTES;

    }
}

