/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.types.ResettableValue;

@Public
public class IntValue
implements NormalizableKey<IntValue>,
ResettableValue<IntValue>,
CopyableValue<IntValue> {
    private static final long serialVersionUID = 1L;
    private int value;

    public IntValue() {
        this.value = 0;
    }

    public IntValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public void setValue(IntValue value) {
        this.value = value.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.value = in.readInt();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.value);
    }

    @Override
    public int compareTo(IntValue o) {
        int other = o.value;
        return this.value < other ? -1 : (this.value > other ? 1 : 0);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntValue) {
            return ((IntValue)obj).value == this.value;
        }
        return false;
    }

    @Override
    public int getMaxNormalizedKeyLen() {
        return 4;
    }

    @Override
    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        block5: {
            block4: {
                if (len != 4) break block4;
                target.putIntBigEndian(offset, this.value - Integer.MIN_VALUE);
                break block5;
            }
            if (len <= 0) break block5;
            if (len < 4) {
                int value = this.value - Integer.MIN_VALUE;
                int i = 0;
                while (len > 0) {
                    target.put(offset + i, (byte)(value >>> (3 - i << 3) & 0xFF));
                    --len;
                    ++i;
                }
            } else {
                target.putIntBigEndian(offset, this.value - Integer.MIN_VALUE);
                for (int i = 4; i < len; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    @Override
    public int getBinaryLength() {
        return 4;
    }

    @Override
    public void copyTo(IntValue target) {
        target.value = this.value;
    }

    @Override
    public IntValue copy() {
        return new IntValue(this.value);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 4);
    }
}

