/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Arrays;

public class BooleanArrayList {
    private int size = 0;
    private boolean[] array;

    public BooleanArrayList(int capacity) {
        this.array = new boolean[capacity];
    }

    public int size() {
        return this.size;
    }

    public boolean add(boolean element) {
        this.grow(this.size + 1);
        this.array[this.size++] = element;
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    private void grow(int length) {
        if (length > this.array.length) {
            int newLength = (int)Math.max(Math.min(2L * (long)this.array.length, 0x7FFFFFF7L), (long)length);
            boolean[] t = new boolean[newLength];
            System.arraycopy(this.array, 0, t, 0, this.size);
            this.array = t;
        }
    }
}

