/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;

public abstract class AbstractIncrementalStateHandle
implements IncrementalKeyedStateHandle {
    private static final long serialVersionUID = 1L;
    protected final long checkpointId;
    protected final UUID backendIdentifier;
    protected final KeyGroupRange keyGroupRange;
    protected final List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState;
    protected final StreamStateHandle metaStateHandle;
    protected final StateHandleID stateHandleId;

    public AbstractIncrementalStateHandle(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState, StreamStateHandle metaStateHandle, StateHandleID stateHandleId) {
        this.checkpointId = checkpointId;
        this.keyGroupRange = keyGroupRange;
        this.backendIdentifier = backendIdentifier;
        this.sharedState = sharedState;
        this.metaStateHandle = metaStateHandle;
        this.stateHandleId = stateHandleId;
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    @Override
    @Nonnull
    public UUID getBackendIdentifier() {
        return this.backendIdentifier;
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    @Nonnull
    public List<IncrementalKeyedStateHandle.HandleAndLocalPath> getSharedStateHandles() {
        return this.sharedState;
    }

    @Override
    @Nonnull
    public StreamStateHandle getMetaDataStateHandle() {
        return this.metaStateHandle;
    }

    @Override
    public StateHandleID getStateHandleId() {
        return this.stateHandleId;
    }

    @Override
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        return KeyGroupRange.EMPTY_KEY_GROUP_RANGE.equals(this.getKeyGroupRange().getIntersection(keyGroupRange)) ? null : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractIncrementalStateHandle that = (AbstractIncrementalStateHandle)o;
        return Objects.equals(this.stateHandleId, that.stateHandleId);
    }

    public int hashCode() {
        return this.stateHandleId.hashCode();
    }

    public String toString() {
        return "AbstractIncrementalStateHandle{checkpointId=" + this.checkpointId + ", backendIdentifier=" + this.backendIdentifier + ", keyGroupRange=" + this.keyGroupRange + ", sharedState=" + this.sharedState + ", metaStateHandle=" + this.metaStateHandle + ", stateHandleId=" + this.stateHandleId + "}";
    }
}

