/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.externalresource.ExternalResourceUtils;
import org.apache.flink.util.Preconditions;

public final class WorkerResourceSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final WorkerResourceSpec ZERO = new Builder().build();
    private final CPUResource cpuCores;
    private final MemorySize taskHeapSize;
    private final MemorySize taskOffHeapSize;
    private final MemorySize networkMemSize;
    private final MemorySize managedMemSize;
    private final int numSlots;
    private final Map<String, ExternalResource> extendedResources;

    private WorkerResourceSpec(CPUResource cpuCores, MemorySize taskHeapSize, MemorySize taskOffHeapSize, MemorySize networkMemSize, MemorySize managedMemSize, int numSlots, Collection<ExternalResource> extendedResources) {
        this.cpuCores = Preconditions.checkNotNull(cpuCores);
        this.taskHeapSize = Preconditions.checkNotNull(taskHeapSize);
        this.taskOffHeapSize = Preconditions.checkNotNull(taskOffHeapSize);
        this.networkMemSize = Preconditions.checkNotNull(networkMemSize);
        this.managedMemSize = Preconditions.checkNotNull(managedMemSize);
        this.numSlots = numSlots;
        this.extendedResources = Preconditions.checkNotNull(extendedResources).stream().filter(resource -> !resource.isZero()).collect(Collectors.toMap(Resource::getName, Function.identity()));
        Preconditions.checkArgument(this.extendedResources.size() == extendedResources.size(), "Duplicate resource name encountered in external resources.");
    }

    public static WorkerResourceSpec fromTaskExecutorProcessSpec(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        Preconditions.checkNotNull(taskExecutorProcessSpec);
        return new WorkerResourceSpec(taskExecutorProcessSpec.getCpuCores(), taskExecutorProcessSpec.getTaskHeapSize(), taskExecutorProcessSpec.getTaskOffHeapSize(), taskExecutorProcessSpec.getNetworkMemSize(), taskExecutorProcessSpec.getManagedMemorySize(), taskExecutorProcessSpec.getNumSlots(), taskExecutorProcessSpec.getExtendedResources().values());
    }

    public static WorkerResourceSpec fromTotalResourceProfile(ResourceProfile resourceProfile, int numSlots) {
        Preconditions.checkNotNull(resourceProfile);
        return new WorkerResourceSpec(resourceProfile.getCpuCores(), resourceProfile.getTaskHeapMemory(), resourceProfile.getTaskOffHeapMemory(), resourceProfile.getNetworkMemory(), resourceProfile.getManagedMemory(), numSlots, resourceProfile.getExtendedResources().values());
    }

    public CPUResource getCpuCores() {
        return this.cpuCores;
    }

    public MemorySize getTaskHeapSize() {
        return this.taskHeapSize;
    }

    public MemorySize getTaskOffHeapSize() {
        return this.taskOffHeapSize;
    }

    public MemorySize getNetworkMemSize() {
        return this.networkMemSize;
    }

    public MemorySize getManagedMemSize() {
        return this.managedMemSize;
    }

    public MemorySize getTotalMemSize() {
        return this.taskHeapSize.add(this.taskOffHeapSize).add(this.networkMemSize).add(this.managedMemSize);
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public Map<String, ExternalResource> getExtendedResources() {
        return Collections.unmodifiableMap(this.extendedResources);
    }

    public int hashCode() {
        return Objects.hash(this.cpuCores, this.taskHeapSize, this.taskOffHeapSize, this.networkMemSize, this.managedMemSize, this.numSlots, this.extendedResources);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == WorkerResourceSpec.class) {
            WorkerResourceSpec that = (WorkerResourceSpec)obj;
            return Objects.equals(this.cpuCores, that.cpuCores) && Objects.equals(this.taskHeapSize, that.taskHeapSize) && Objects.equals(this.taskOffHeapSize, that.taskOffHeapSize) && Objects.equals(this.networkMemSize, that.networkMemSize) && Objects.equals(this.managedMemSize, that.managedMemSize) && Objects.equals(this.numSlots, that.numSlots) && Objects.equals(this.extendedResources, that.extendedResources);
        }
        return false;
    }

    public String toString() {
        return "WorkerResourceSpec {cpuCores=" + this.cpuCores.getValue().doubleValue() + ", taskHeapSize=" + this.taskHeapSize.toHumanReadableString() + ", taskOffHeapSize=" + this.taskOffHeapSize.toHumanReadableString() + ", networkMemSize=" + this.networkMemSize.toHumanReadableString() + ", managedMemSize=" + this.managedMemSize.toHumanReadableString() + ", numSlots=" + this.numSlots + (String)(this.extendedResources.isEmpty() ? "" : ", " + ExternalResourceUtils.generateExternalResourcesString(this.extendedResources.values())) + "}";
    }

    public static class Builder {
        private CPUResource cpuCores = new CPUResource(0.0);
        private MemorySize taskHeapSize = MemorySize.ZERO;
        private MemorySize taskOffHeapSize = MemorySize.ZERO;
        private MemorySize networkMemSize = MemorySize.ZERO;
        private MemorySize managedMemSize = MemorySize.ZERO;
        private int numSlots = 1;
        private Map<String, ExternalResource> extendedResources = new HashMap<String, ExternalResource>();

        public Builder setCpuCores(double cpuCores) {
            this.cpuCores = new CPUResource(cpuCores);
            return this;
        }

        public Builder setTaskHeapMemoryMB(int taskHeapMemoryMB) {
            this.taskHeapSize = MemorySize.ofMebiBytes(taskHeapMemoryMB);
            return this;
        }

        public Builder setTaskOffHeapMemoryMB(int taskOffHeapMemoryMB) {
            this.taskOffHeapSize = MemorySize.ofMebiBytes(taskOffHeapMemoryMB);
            return this;
        }

        public Builder setNetworkMemoryMB(int networkMemoryMB) {
            this.networkMemSize = MemorySize.ofMebiBytes(networkMemoryMB);
            return this;
        }

        public Builder setManagedMemoryMB(int managedMemoryMB) {
            this.managedMemSize = MemorySize.ofMebiBytes(managedMemoryMB);
            return this;
        }

        public Builder setNumSlots(int numSlots) {
            this.numSlots = numSlots;
            return this;
        }

        public Builder setExtendedResource(ExternalResource extendedResource) {
            this.extendedResources.put(extendedResource.getName(), extendedResource);
            return this;
        }

        public Builder setExtendedResources(Collection<ExternalResource> extendedResources) {
            this.extendedResources = extendedResources.stream().collect(Collectors.toMap(Resource::getName, Function.identity()));
            return this;
        }

        public WorkerResourceSpec build() {
            return new WorkerResourceSpec(this.cpuCores, this.taskHeapSize, this.taskOffHeapSize, this.networkMemSize, this.managedMemSize, this.numSlots, this.extendedResources.values());
        }
    }
}

