/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.operators.sort.ExceptionHandler;
import org.apache.flink.runtime.operators.sort.StageRunner;
import org.apache.flink.util.Preconditions;

abstract class ThreadBase<E>
extends Thread
implements Thread.UncaughtExceptionHandler,
StageRunner {
    protected final StageRunner.StageMessageDispatcher<E> dispatcher;
    private final ExceptionHandler<IOException> exceptionHandler;
    private volatile boolean alive;

    protected ThreadBase(@Nullable ExceptionHandler<IOException> exceptionHandler, String name, StageRunner.StageMessageDispatcher<E> queues) {
        super(Preconditions.checkNotNull(name));
        this.setDaemon(true);
        this.exceptionHandler = exceptionHandler;
        this.setUncaughtExceptionHandler(this);
        this.dispatcher = Preconditions.checkNotNull(queues);
        this.alive = true;
    }

    @Override
    public void run() {
        try {
            this.go();
        }
        catch (Throwable t) {
            this.internalHandleException(new IOException("Thread '" + this.getName() + "' terminated due to an exception: " + t.getMessage(), t));
        }
    }

    protected abstract void go() throws IOException, InterruptedException;

    protected boolean isRunning() {
        return this.alive;
    }

    @Override
    public void close() throws InterruptedException {
        this.alive = false;
        this.interrupt();
        this.join();
    }

    protected final void internalHandleException(IOException ioex) {
        if (!this.isRunning()) {
            return;
        }
        if (this.exceptionHandler != null) {
            try {
                this.exceptionHandler.handleException(ioex);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.internalHandleException(new IOException("Thread '" + t.getName() + "' terminated due to an uncaught exception: " + e.getMessage(), e));
    }
}

