/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.checkpoint.AbstractCheckpointMessage;
import org.apache.flink.runtime.messages.checkpoint.SerializedCheckpointException;
import org.apache.flink.util.Preconditions;

public class DeclineCheckpoint
extends AbstractCheckpointMessage
implements Serializable {
    private static final long serialVersionUID = 2094094662279578953L;
    private final SerializedCheckpointException serializedCheckpointException;

    public DeclineCheckpoint(JobID job, ExecutionAttemptID taskExecutionId, long checkpointId, CheckpointException checkpointException) {
        super(job, taskExecutionId, checkpointId);
        Preconditions.checkNotNull(checkpointException, "The checkpoint exception must not be null.");
        this.serializedCheckpointException = new SerializedCheckpointException(checkpointException);
    }

    @Nonnull
    public SerializedCheckpointException getSerializedCheckpointException() {
        return this.serializedCheckpointException;
    }

    @Override
    public String toString() {
        return String.format("Declined Checkpoint %d for (%s/%s): %s", new Object[]{this.getCheckpointId(), this.getJob(), this.getTaskExecutionId(), this.serializedCheckpointException.getCheckpointFailureReason()});
    }
}

