/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.util.Preconditions;

public class NettyPartitionRequestListener
implements PartitionRequestListener {
    private final ResultPartitionProvider resultPartitionProvider;
    private final NetworkSequenceViewReader reader;
    private final ResultSubpartitionIndexSet subpartitionIndexSet;
    private final ResultPartitionID resultPartitionId;
    private final long createTimestamp;

    public NettyPartitionRequestListener(ResultPartitionProvider resultPartitionProvider, NetworkSequenceViewReader reader, ResultSubpartitionIndexSet subpartitionIndexSet, ResultPartitionID resultPartitionId) {
        this(resultPartitionProvider, reader, subpartitionIndexSet, resultPartitionId, System.currentTimeMillis());
    }

    @VisibleForTesting
    public NettyPartitionRequestListener(ResultPartitionProvider resultPartitionProvider, NetworkSequenceViewReader reader, ResultSubpartitionIndexSet subpartitionIndexSet, ResultPartitionID resultPartitionId, long createTimestamp) {
        this.resultPartitionProvider = resultPartitionProvider;
        this.reader = reader;
        this.subpartitionIndexSet = subpartitionIndexSet;
        this.resultPartitionId = resultPartitionId;
        this.createTimestamp = createTimestamp;
    }

    @Override
    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    @Override
    public ResultPartitionID getResultPartitionId() {
        return this.resultPartitionId;
    }

    @Override
    public NetworkSequenceViewReader getViewReader() {
        return this.reader;
    }

    @Override
    public InputChannelID getReceiverId() {
        return this.reader.getReceiverId();
    }

    @Override
    public void notifyPartitionCreated(ResultPartition partition) throws IOException {
        Preconditions.checkNotNull(partition);
        this.reader.notifySubpartitionsCreated(partition, this.subpartitionIndexSet);
    }

    @Override
    public void notifyPartitionCreatedTimeout() {
        this.reader.notifyPartitionRequestTimeout(this);
    }

    @Override
    public void releaseListener() {
        this.resultPartitionProvider.releasePartitionRequestListener(this);
    }
}

