/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.YamlParserUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class GlobalConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalConfiguration.class);
    public static final String FLINK_CONF_FILENAME = "config.yaml";
    private static final String KEY_SEPARATOR = ".";
    private static final String[] SENSITIVE_KEYS = new String[]{"password", "secret", "fs.azure.account.key", "apikey", "api-key", "auth-params", "service-key", "token", "basic-auth", "jaas.config", "http-headers"};
    public static final String HIDDEN_CONTENT = "******";

    private GlobalConfiguration() {
    }

    public static Configuration loadConfiguration() {
        return GlobalConfiguration.loadConfiguration(new Configuration());
    }

    public static Configuration loadConfiguration(Configuration dynamicProperties) {
        String configDir = System.getenv("FLINK_CONF_DIR");
        if (configDir == null) {
            return new Configuration(dynamicProperties);
        }
        return GlobalConfiguration.loadConfiguration(configDir, dynamicProperties);
    }

    public static Configuration loadConfiguration(String configDir) {
        return GlobalConfiguration.loadConfiguration(configDir, null);
    }

    public static Configuration loadConfiguration(String configDir, @Nullable Configuration dynamicProperties) {
        if (configDir == null) {
            throw new IllegalArgumentException("Given configuration directory is null, cannot load configuration");
        }
        File confDirFile = new File(configDir);
        if (!confDirFile.exists()) {
            throw new IllegalConfigurationException("The given configuration directory name '" + configDir + "' (" + confDirFile.getAbsolutePath() + ") does not describe an existing directory.");
        }
        File yamlConfigFile = new File(confDirFile, FLINK_CONF_FILENAME);
        if (!yamlConfigFile.exists()) {
            throw new IllegalConfigurationException("The Flink config file '" + yamlConfigFile + "' (" + yamlConfigFile.getAbsolutePath() + ") does not exist.");
        }
        LOG.info("Using standard YAML parser to load flink configuration file from {}.", (Object)yamlConfigFile.getAbsolutePath());
        Configuration configuration = GlobalConfiguration.loadYAMLResource(yamlConfigFile);
        GlobalConfiguration.logConfiguration("Loading", configuration);
        if (dynamicProperties != null) {
            GlobalConfiguration.logConfiguration("Loading dynamic", dynamicProperties);
            configuration.addAll(dynamicProperties);
        }
        return configuration;
    }

    private static void logConfiguration(String prefix, Configuration config) {
        config.confData.forEach((key, value) -> LOG.info("{} configuration property: {}, {}", new Object[]{prefix, key, GlobalConfiguration.isSensitive(key) ? HIDDEN_CONTENT : value}));
    }

    private static void flatten(Map<String, Object> config, String keyPrefix, Map<String, Object> flattenedMap) {
        config.forEach((key, value) -> {
            String flattenedKey = keyPrefix + key;
            if (value instanceof Map) {
                Map nestedMap = (Map)value;
                GlobalConfiguration.flatten(nestedMap, flattenedKey + KEY_SEPARATOR, flattenedMap);
            } else if (value instanceof List) {
                flattenedMap.put(flattenedKey, YamlParserUtils.toYAMLString(value));
            } else {
                flattenedMap.put(flattenedKey, value);
            }
        });
    }

    private static Map<String, Object> flatten(Map<String, Object> config) {
        HashMap<String, Object> flattenedMap = new HashMap<String, Object>();
        GlobalConfiguration.flatten(config, "", flattenedMap);
        return flattenedMap;
    }

    private static Configuration loadYAMLResource(File file) {
        Configuration config = new Configuration();
        try {
            Map<String, Object> configDocument = GlobalConfiguration.flatten(YamlParserUtils.loadYamlFile(file));
            configDocument.forEach((k, v) -> config.setValueInternal((String)k, v, false));
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing YAML configuration.", e);
        }
    }

    public static boolean isSensitive(String key) {
        Preconditions.checkNotNull(key, "key is null");
        String keyInLower = key.toLowerCase();
        for (String hideKey : SENSITIVE_KEYS) {
            if (keyInLower.length() < hideKey.length() || !keyInLower.contains(hideKey)) continue;
            return true;
        }
        return false;
    }

    public static String getFlinkConfFilename() {
        return FLINK_CONF_FILENAME;
    }
}

