/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.EnumComparator;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.util.Preconditions;

@Public
public class EnumTypeInfo<T extends Enum<T>>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 8936740290137178660L;
    private final Class<T> typeClass;

    @PublicEvolving
    public EnumTypeInfo(Class<T> typeClass) {
        Preconditions.checkNotNull(typeClass, "Enum type class must not be null.");
        if (!Enum.class.isAssignableFrom(typeClass)) {
            throw new IllegalArgumentException("EnumTypeInfo can only be used for subclasses of " + Enum.class.getName());
        }
        this.typeClass = typeClass;
    }

    @Override
    @PublicEvolving
    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        return new EnumComparator(sortOrderAscending);
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @Override
    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        return true;
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(SerializerConfig serializerConfig) {
        return new EnumSerializer<T>(this.typeClass);
    }

    @Override
    public String toString() {
        return "EnumTypeInfo<" + this.typeClass.getName() + ">";
    }

    @Override
    public int hashCode() {
        return this.typeClass.hashCode();
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof EnumTypeInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EnumTypeInfo) {
            EnumTypeInfo enumTypeInfo = (EnumTypeInfo)obj;
            return enumTypeInfo.canEqual(this) && this.typeClass == enumTypeInfo.typeClass;
        }
        return false;
    }
}

