/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;

@Internal
public final class CollectionUtil {
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    static final float HASH_MAP_DEFAULT_LOAD_FACTOR = 0.75f;

    private CollectionUtil() {
        throw new AssertionError();
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmptyOrAllElementsNull(Collection<?> collection) {
        for (Object o : collection) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> Set<T> ofNullable(@Nullable T obj) {
        return obj == null ? Collections.emptySet() : Collections.singleton(obj);
    }

    public static <T, R> Stream<R> mapWithIndex(Collection<T> input, BiFunction<T, Integer, R> mapper) {
        AtomicInteger count = new AtomicInteger(0);
        return input.stream().map(element -> mapper.apply(element, count.getAndIncrement()));
    }

    public static <T> Collection<List<T>> partition(Collection<T> elements, int numBuckets) {
        HashMap<Integer, List> buckets = CollectionUtil.newHashMapWithExpectedSize(numBuckets);
        int initialCapacity = elements.size() / numBuckets;
        int index = 0;
        for (T element : elements) {
            int bucket = index % numBuckets;
            buckets.computeIfAbsent(bucket, key -> new ArrayList(initialCapacity)).add(element);
            ++index;
        }
        return buckets.values();
    }

    public static <I, O> Collection<O> project(Collection<I> collection, Function<I, O> projector) {
        return collection.stream().map(projector).collect(Collectors.toList());
    }

    public static <E> List<E> iterableToList(@Nullable Iterable<E> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        iterable.iterator().forEachRemaining(list::add);
        return list;
    }

    public static <E> List<E> iteratorToList(@Nullable Iterator<E> iterator) {
        if (iterator == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        iterator.forEachRemaining(list::add);
        return list;
    }

    public static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> map(Map.Entry<K, V> ... entries) {
        if (entries == null) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionUtil.computeRequiredCapacity(expectedSize, 0.75f), 0.75f);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(CollectionUtil.computeRequiredCapacity(expectedSize, 0.75f), 0.75f);
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(CollectionUtil.computeRequiredCapacity(expectedSize, 0.75f), 0.75f);
    }

    public static <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(CollectionUtil.computeRequiredCapacity(expectedSize, 0.75f), 0.75f);
    }

    @VisibleForTesting
    static int computeRequiredCapacity(int expectedSize, float loadFactor) {
        Preconditions.checkArgument(expectedSize >= 0);
        Preconditions.checkArgument(loadFactor > 0.0f);
        if (expectedSize <= 2) {
            return expectedSize + 1;
        }
        return expectedSize < 0x40000000 ? (int)Math.ceil((float)expectedSize / loadFactor) : Integer.MAX_VALUE;
    }

    public static <T> Collection<T> subTypeCast(Collection<? super T> collection) {
        Collection<? super T> result = collection;
        return result;
    }

    public static <T> Collection<T> checkedSubTypeCast(Collection<? super T> collection, Class<T> subTypeClass) {
        for (T o : collection) {
            subTypeClass.cast(o);
        }
        return CollectionUtil.subTypeCast(collection);
    }
}

