/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;

@Public
public final class NullValue
implements NormalizableKey<NullValue>,
CopyableValue<NullValue> {
    private static final long serialVersionUID = 1L;
    private static final NullValue INSTANCE = new NullValue();

    public static NullValue getInstance() {
        return INSTANCE;
    }

    public String toString() {
        return "(null)";
    }

    @Override
    public void read(DataInputView in) throws IOException {
        in.readBoolean();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeBoolean(false);
    }

    @Override
    public int compareTo(NullValue o) {
        return 0;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == NullValue.class;
    }

    public int hashCode() {
        return 53;
    }

    @Override
    public int getMaxNormalizedKeyLen() {
        return 0;
    }

    @Override
    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        for (int i = offset; i < offset + len; ++i) {
            target.put(i, (byte)0);
        }
    }

    @Override
    public int getBinaryLength() {
        return 1;
    }

    @Override
    public void copyTo(NullValue target) {
    }

    @Override
    public NullValue copy() {
        return NullValue.getInstance();
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        source.readBoolean();
        target.writeBoolean(false);
    }
}

