/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.SqlCallSyntax;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class CallExpression
implements ResolvedExpression {
    private final boolean isTemporary;
    @Nullable
    private final FunctionIdentifier functionIdentifier;
    private final FunctionDefinition functionDefinition;
    private final List<ResolvedExpression> args;
    private final DataType dataType;

    @Internal
    public CallExpression(boolean isTemporary, @Nullable FunctionIdentifier functionIdentifier, FunctionDefinition functionDefinition, List<ResolvedExpression> args, DataType dataType) {
        this.isTemporary = isTemporary;
        this.functionIdentifier = functionIdentifier;
        this.functionDefinition = Preconditions.checkNotNull(functionDefinition, "Function definition must not be null.");
        this.args = new ArrayList<ResolvedExpression>((Collection)Preconditions.checkNotNull(args, "Arguments must not be null."));
        this.dataType = Preconditions.checkNotNull(dataType, "Data type must not be null.");
    }

    public static CallExpression permanent(FunctionIdentifier functionIdentifier, FunctionDefinition functionDefinition, List<ResolvedExpression> args, DataType dataType) {
        return new CallExpression(false, Preconditions.checkNotNull(functionIdentifier, "Function identifier must not be null for permanent functions."), functionDefinition, args, dataType);
    }

    @Internal
    public static CallExpression permanent(BuiltInFunctionDefinition builtInFunctionDefinition, List<ResolvedExpression> args, DataType dataType) {
        return new CallExpression(false, FunctionIdentifier.of(builtInFunctionDefinition.getName()), builtInFunctionDefinition, args, dataType);
    }

    public static CallExpression temporary(FunctionIdentifier functionIdentifier, FunctionDefinition functionDefinition, List<ResolvedExpression> args, DataType dataType) {
        return new CallExpression(true, Preconditions.checkNotNull(functionIdentifier, "Function identifier must not be null for temporary functions."), functionDefinition, args, dataType);
    }

    public static CallExpression anonymous(FunctionDefinition functionDefinition, List<ResolvedExpression> args, DataType dataType) {
        return new CallExpression(true, null, functionDefinition, args, dataType);
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public Optional<FunctionIdentifier> getFunctionIdentifier() {
        return Optional.ofNullable(this.functionIdentifier);
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    public String getFunctionName() {
        if (this.functionIdentifier == null) {
            return this.functionDefinition.toString();
        }
        return this.functionIdentifier.asSummaryString();
    }

    public CallExpression replaceArgs(List<ResolvedExpression> args, DataType dataType) {
        return new CallExpression(this.isTemporary, this.functionIdentifier, this.functionDefinition, args, dataType);
    }

    @Override
    public DataType getOutputDataType() {
        return this.dataType;
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        return this.args;
    }

    @Override
    public String asSummaryString() {
        String argList = this.args.stream().map(Expression::asSummaryString).collect(Collectors.joining(", ", "(", ")"));
        return this.getFunctionName() + argList;
    }

    @Override
    public String asSerializableString() {
        if (this.functionDefinition instanceof BuiltInFunctionDefinition) {
            BuiltInFunctionDefinition definition = (BuiltInFunctionDefinition)this.functionDefinition;
            return definition.getCallSyntax().unparse(definition.getSqlName(), this.args);
        }
        return SqlCallSyntax.FUNCTION.unparse(this.getSerializableFunctionName(), this.args);
    }

    private String getSerializableFunctionName() {
        if (this.functionIdentifier == null) {
            throw new TableException("Only functions that have been registered before are serializable.");
        }
        return this.functionIdentifier.getIdentifier().map(ObjectIdentifier::asSerializableString).orElseGet(() -> EncodingUtils.escapeIdentifier(this.functionIdentifier.getFunctionName()));
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallExpression that = (CallExpression)o;
        return this.isTemporary == that.isTemporary && Objects.equals(this.functionIdentifier, that.functionIdentifier) && this.functionDefinition.equals(that.functionDefinition) && this.args.equals(that.args) && this.dataType.equals(that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.isTemporary, this.functionIdentifier, this.functionDefinition, this.args, this.dataType);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

