/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.JarUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class RemoteEnvironmentConfigUtils {
    public static void validate(String host, int port) {
        if (!StreamExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The RemoteEnvironment cannot be instantiated when running in a pre-defined context (such as Command Line Client or TestEnvironment)");
        }
        Preconditions.checkNotNull(host);
        Preconditions.checkArgument(port > 0 && port < 65535);
    }

    public static void setJobManagerAddressToConfig(String host, int port, Configuration configuration) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        configuration.set((ConfigOption)JobManagerOptions.ADDRESS, address.getHostString());
        configuration.set((ConfigOption)JobManagerOptions.PORT, (Object)address.getPort());
        configuration.set((ConfigOption)RestOptions.ADDRESS, address.getHostString());
        configuration.set((ConfigOption)RestOptions.PORT, (Object)address.getPort());
    }

    public static void setJarURLsToConfig(String[] jars, Configuration configuration) {
        List<URL> jarURLs = RemoteEnvironmentConfigUtils.getJarFiles(jars);
        ConfigUtils.encodeCollectionToConfig(configuration, PipelineOptions.JARS, jarURLs, URL::toString);
    }

    private static List<URL> getJarFiles(String[] jars) {
        return jars == null ? Collections.emptyList() : Arrays.stream(jars).map(jarPath -> {
            try {
                URL fileURL = new File((String)jarPath).getAbsoluteFile().toURI().toURL();
                JarUtils.checkJarFile(fileURL);
                return fileURL;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("JAR file path invalid", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem with jar file " + jarPath, e);
            }
        }).collect(Collectors.toList());
    }
}

