/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.legacy.YieldingOperatorFactory;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeServiceAware;
import org.apache.flink.util.Preconditions;

@Experimental
public abstract class AbstractStreamOperatorFactory<OUT>
implements StreamOperatorFactory<OUT>,
ProcessingTimeServiceAware {
    protected ChainingStrategy chainingStrategy = ChainingStrategy.DEFAULT_CHAINING_STRATEGY;
    protected transient ProcessingTimeService processingTimeService;
    @Nullable
    private transient MailboxExecutor mailboxExecutor;

    @Override
    public void setChainingStrategy(ChainingStrategy strategy) {
        this.chainingStrategy = strategy;
    }

    @Override
    public ChainingStrategy getChainingStrategy() {
        return this.chainingStrategy;
    }

    @Override
    public void setProcessingTimeService(ProcessingTimeService processingTimeService) {
        this.processingTimeService = processingTimeService;
    }

    public void setMailboxExecutor(MailboxExecutor mailboxExecutor) {
        this.mailboxExecutor = mailboxExecutor;
    }

    protected MailboxExecutor getMailboxExecutor() {
        return Preconditions.checkNotNull(this.mailboxExecutor, "Factory does not implement %s", YieldingOperatorFactory.class);
    }
}

