/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.WrappingFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Internal
public class AggregateApplyWindowFunction<K, W extends Window, T, ACC, V, R>
extends WrappingFunction<WindowFunction<V, R, K, W>>
implements WindowFunction<T, R, K, W> {
    private static final long serialVersionUID = 1L;
    private final AggregateFunction<T, ACC, V> aggFunction;

    public AggregateApplyWindowFunction(AggregateFunction<T, ACC, V> aggFunction, WindowFunction<V, R, K, W> windowFunction) {
        super(windowFunction);
        this.aggFunction = aggFunction;
    }

    @Override
    public void apply(K key, W window, Iterable<T> values, Collector<R> out) throws Exception {
        ACC acc = this.aggFunction.createAccumulator();
        for (T val : values) {
            acc = this.aggFunction.add(val, acc);
        }
        ((WindowFunction)this.wrappedFunction).apply(key, window, Collections.singletonList(this.aggFunction.getResult(acc)), out);
    }
}

