/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.shaded.guava32.com.google.common.base.MoreObjects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class TaskExecutorMemoryConfiguration
implements Serializable {
    public static final String FIELD_NAME_FRAMEWORK_HEAP = "frameworkHeap";
    public static final String FIELD_NAME_TASK_HEAP = "taskHeap";
    public static final String FIELD_NAME_FRAMEWORK_OFFHEAP = "frameworkOffHeap";
    public static final String FIELD_NAME_TASK_OFFHEAP = "taskOffHeap";
    public static final String FIELD_NAME_NETWORK_MEMORY = "networkMemory";
    public static final String FIELD_NAME_MANAGED_MEMORY = "managedMemory";
    public static final String FIELD_NAME_JVM_METASPACE = "jvmMetaspace";
    public static final String FIELD_NAME_JVM_OVERHEAD = "jvmOverhead";
    public static final String FIELD_NAME_TOTAL_FLINK_MEMORY = "totalFlinkMemory";
    public static final String FIELD_NAME_TOTAL_PROCESS_MEMORY = "totalProcessMemory";
    @JsonProperty(value="frameworkHeap")
    @JsonInclude
    private final Long frameworkHeap;
    @JsonProperty(value="taskHeap")
    private final Long taskHeap;
    @JsonProperty(value="frameworkOffHeap")
    private final Long frameworkOffHeap;
    @JsonProperty(value="taskOffHeap")
    private final Long taskOffHeap;
    @JsonProperty(value="networkMemory")
    private final Long networkMemory;
    @JsonProperty(value="managedMemory")
    private final Long managedMemoryTotal;
    @JsonProperty(value="jvmMetaspace")
    private final Long jvmMetaspace;
    @JsonProperty(value="jvmOverhead")
    private final Long jvmOverhead;
    @JsonProperty(value="totalFlinkMemory")
    private final Long totalFlinkMemory;
    @JsonProperty(value="totalProcessMemory")
    private final Long totalProcessMemory;

    private static Long getConfigurationValue(Configuration config, ConfigOption<? extends MemorySize> option) {
        MemorySize memorySize = config.get(option);
        return memorySize != null ? Long.valueOf(memorySize.getBytes()) : null;
    }

    public static TaskExecutorMemoryConfiguration create(Configuration config) {
        return new TaskExecutorMemoryConfiguration(TaskExecutorMemoryConfiguration.getConfigurationValue(config, TaskManagerOptions.FRAMEWORK_HEAP_MEMORY), TaskExecutorMemoryConfiguration.getConfigurationValue(config, TaskManagerOptions.TASK_HEAP_MEMORY), TaskExecutorMemoryConfiguration.getConfigurationValue(config, TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY), TaskExecutorMemoryConfiguration.getConfigurationValue(config, TaskManagerOptions.TASK_OFF_HEAP_MEMORY), TaskExecutorMemoryConfiguration.getConfigurationValue(config, TaskManagerOptions.NETWORK_MEMORY_MAX), TaskExecutorMemoryConfiguration.getConfigurationValue(config, TaskManagerOptions.MANAGED_MEMORY_SIZE), TaskExecutorMemoryConfiguration.getConfigurationValue(config, TaskManagerOptions.JVM_METASPACE), TaskExecutorMemoryConfiguration.getConfigurationValue(config, TaskManagerOptions.JVM_OVERHEAD_MAX), TaskExecutorResourceUtils.calculateTotalFlinkMemoryFromComponents(config), TaskExecutorResourceUtils.calculateTotalProcessMemoryFromComponents(config));
    }

    @JsonCreator
    public TaskExecutorMemoryConfiguration(@JsonProperty(value="frameworkHeap") Long frameworkHeap, @JsonProperty(value="taskHeap") Long taskHeap, @JsonProperty(value="frameworkOffHeap") Long frameworkOffHeap, @JsonProperty(value="taskOffHeap") Long taskOffHeap, @JsonProperty(value="networkMemory") Long networkMemory, @JsonProperty(value="managedMemory") Long managedMemoryTotal, @JsonProperty(value="jvmMetaspace") Long jvmMetaspace, @JsonProperty(value="jvmOverhead") Long jvmOverhead, @JsonProperty(value="totalFlinkMemory") Long totalFlinkMemory, @JsonProperty(value="totalProcessMemory") Long totalProcessMemory) {
        this.frameworkHeap = frameworkHeap;
        this.taskHeap = taskHeap;
        this.frameworkOffHeap = frameworkOffHeap;
        this.taskOffHeap = taskOffHeap;
        this.networkMemory = networkMemory;
        this.managedMemoryTotal = managedMemoryTotal;
        this.jvmMetaspace = jvmMetaspace;
        this.jvmOverhead = jvmOverhead;
        this.totalFlinkMemory = totalFlinkMemory;
        this.totalProcessMemory = totalProcessMemory;
    }

    public Long getFrameworkHeap() {
        return this.frameworkHeap;
    }

    public Long getTaskHeap() {
        return this.taskHeap;
    }

    public Long getFrameworkOffHeap() {
        return this.frameworkOffHeap;
    }

    public Long getTaskOffHeap() {
        return this.taskOffHeap;
    }

    public Long getNetworkMemory() {
        return this.networkMemory;
    }

    public Long getManagedMemoryTotal() {
        return this.managedMemoryTotal;
    }

    public Long getJvmMetaspace() {
        return this.jvmMetaspace;
    }

    public Long getJvmOverhead() {
        return this.jvmOverhead;
    }

    public Long getTotalFlinkMemory() {
        return this.totalFlinkMemory;
    }

    public Long getTotalProcessMemory() {
        return this.totalProcessMemory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskExecutorMemoryConfiguration that = (TaskExecutorMemoryConfiguration)o;
        return Objects.equals(this.frameworkHeap, that.frameworkHeap) && Objects.equals(this.taskHeap, that.taskHeap) && Objects.equals(this.frameworkOffHeap, that.frameworkOffHeap) && Objects.equals(this.taskOffHeap, that.taskOffHeap) && Objects.equals(this.networkMemory, that.networkMemory) && Objects.equals(this.managedMemoryTotal, that.managedMemoryTotal) && Objects.equals(this.jvmMetaspace, that.jvmMetaspace) && Objects.equals(this.jvmOverhead, that.jvmOverhead) && Objects.equals(this.totalFlinkMemory, that.totalFlinkMemory) && Objects.equals(this.totalProcessMemory, that.totalProcessMemory);
    }

    public int hashCode() {
        return Objects.hash(this.frameworkHeap, this.taskHeap, this.frameworkOffHeap, this.taskOffHeap, this.networkMemory, this.managedMemoryTotal, this.jvmMetaspace, this.jvmOverhead, this.totalFlinkMemory, this.totalProcessMemory);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add(FIELD_NAME_FRAMEWORK_HEAP, this.frameworkHeap).add(FIELD_NAME_TASK_HEAP, this.taskHeap).add(FIELD_NAME_FRAMEWORK_OFFHEAP, this.frameworkOffHeap).add(FIELD_NAME_TASK_OFFHEAP, this.taskOffHeap).add(FIELD_NAME_NETWORK_MEMORY, this.networkMemory).add(FIELD_NAME_MANAGED_MEMORY, this.managedMemoryTotal).add(FIELD_NAME_JVM_METASPACE, this.jvmMetaspace).add(FIELD_NAME_JVM_OVERHEAD, this.jvmOverhead).add(FIELD_NAME_TOTAL_FLINK_MEMORY, this.totalFlinkMemory).add(FIELD_NAME_TOTAL_PROCESS_MEMORY, this.totalProcessMemory).toString();
    }
}

