/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.state.v2.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.v2.StateDescriptor;

public class StateDescriptorUtils {
    private StateDescriptorUtils() {
    }

    public static org.apache.flink.api.common.state.StateDescriptor transformFromV2ToV1(StateDescriptor stateDescriptor) {
        switch (stateDescriptor.getType()) {
            case VALUE: {
                return StateDescriptorUtils.transformFromV2ToV1((org.apache.flink.api.common.state.v2.ValueStateDescriptor)stateDescriptor);
            }
            case MAP: {
                return StateDescriptorUtils.transformFromV2ToV1((org.apache.flink.api.common.state.v2.MapStateDescriptor)stateDescriptor);
            }
            case LIST: {
                return StateDescriptorUtils.transformFromV2ToV1((org.apache.flink.api.common.state.v2.ListStateDescriptor)stateDescriptor);
            }
            case REDUCING: {
                return StateDescriptorUtils.transformFromV2ToV1((org.apache.flink.api.common.state.v2.ReducingStateDescriptor)stateDescriptor);
            }
            case AGGREGATING: {
                return StateDescriptorUtils.transformFromV2ToV1((AggregatingStateDescriptor)stateDescriptor);
            }
        }
        throw new IllegalArgumentException("Unsupported state type: " + stateDescriptor.getType());
    }

    public static <V> ValueStateDescriptor<V> transformFromV2ToV1(org.apache.flink.api.common.state.v2.ValueStateDescriptor<V> stateDescriptor) {
        if (stateDescriptor.isSerializerInitialized()) {
            return new ValueStateDescriptor(stateDescriptor.getStateId(), stateDescriptor.getSerializer());
        }
        return new ValueStateDescriptor(stateDescriptor.getStateId(), stateDescriptor.getTypeInformation());
    }

    public static <UK, UV> MapStateDescriptor<UK, UV> transformFromV2ToV1(org.apache.flink.api.common.state.v2.MapStateDescriptor<UK, UV> stateDescriptor) {
        if (stateDescriptor.isSerializerInitialized()) {
            return new MapStateDescriptor(stateDescriptor.getStateId(), stateDescriptor.getUserKeySerializer(), stateDescriptor.getSerializer());
        }
        return new MapStateDescriptor(stateDescriptor.getStateId(), stateDescriptor.getUserKeyTypeInformation(), stateDescriptor.getTypeInformation());
    }

    public static <V> ListStateDescriptor<V> transformFromV2ToV1(org.apache.flink.api.common.state.v2.ListStateDescriptor<V> stateDescriptor) {
        if (stateDescriptor.isSerializerInitialized()) {
            return new ListStateDescriptor(stateDescriptor.getStateId(), stateDescriptor.getSerializer());
        }
        return new ListStateDescriptor(stateDescriptor.getStateId(), stateDescriptor.getTypeInformation());
    }

    public static <V> ReducingStateDescriptor<V> transformFromV2ToV1(org.apache.flink.api.common.state.v2.ReducingStateDescriptor<V> stateDescriptor) {
        if (stateDescriptor.isSerializerInitialized()) {
            return new ReducingStateDescriptor<V>(stateDescriptor.getStateId(), stateDescriptor.getReduceFunction(), stateDescriptor.getSerializer());
        }
        return new ReducingStateDescriptor<V>(stateDescriptor.getStateId(), stateDescriptor.getReduceFunction(), stateDescriptor.getTypeInformation());
    }

    public static <IN, ACC, OUT> org.apache.flink.api.common.state.AggregatingStateDescriptor<IN, ACC, OUT> transformFromV2ToV1(AggregatingStateDescriptor<IN, ACC, OUT> stateDescriptor) {
        if (stateDescriptor.isSerializerInitialized()) {
            return new org.apache.flink.api.common.state.AggregatingStateDescriptor<IN, ACC, OUT>(stateDescriptor.getStateId(), stateDescriptor.getAggregateFunction(), stateDescriptor.getSerializer());
        }
        return new org.apache.flink.api.common.state.AggregatingStateDescriptor<IN, ACC, OUT>(stateDescriptor.getStateId(), stateDescriptor.getAggregateFunction(), stateDescriptor.getTypeInformation());
    }
}

