/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public class PartitionDescriptor
implements Serializable {
    private static final long serialVersionUID = 6343547936086963705L;
    private final IntermediateDataSetID resultId;
    private final int totalNumberOfPartitions;
    private final IntermediateResultPartitionID partitionId;
    private final ResultPartitionType partitionType;
    private final int numberOfSubpartitions;
    private final int connectionIndex;
    private final boolean isBroadcast;
    private final boolean isAllToAllDistribution;
    private final boolean isNumberOfPartitionConsumerUndefined;

    @VisibleForTesting
    public PartitionDescriptor(IntermediateDataSetID resultId, int totalNumberOfPartitions, IntermediateResultPartitionID partitionId, ResultPartitionType partitionType, int numberOfSubpartitions, int connectionIndex, boolean isBroadcast, boolean isAllToAllDistribution, boolean isNumberOfPartitionConsumerUndefined) {
        this.resultId = Preconditions.checkNotNull(resultId);
        Preconditions.checkArgument(totalNumberOfPartitions >= 1);
        this.totalNumberOfPartitions = totalNumberOfPartitions;
        this.partitionId = Preconditions.checkNotNull(partitionId);
        this.partitionType = Preconditions.checkNotNull(partitionType);
        Preconditions.checkArgument(numberOfSubpartitions >= 1);
        this.numberOfSubpartitions = numberOfSubpartitions;
        this.connectionIndex = connectionIndex;
        this.isBroadcast = isBroadcast;
        this.isAllToAllDistribution = isAllToAllDistribution;
        this.isNumberOfPartitionConsumerUndefined = isNumberOfPartitionConsumerUndefined;
    }

    public IntermediateDataSetID getResultId() {
        return this.resultId;
    }

    public int getTotalNumberOfPartitions() {
        return this.totalNumberOfPartitions;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    public int getNumberOfSubpartitions() {
        return this.numberOfSubpartitions;
    }

    public boolean isNumberOfPartitionConsumerUndefined() {
        return this.isNumberOfPartitionConsumerUndefined;
    }

    int getConnectionIndex() {
        return this.connectionIndex;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public boolean isAllToAllDistribution() {
        return this.isAllToAllDistribution;
    }

    public String toString() {
        return String.format("PartitionDescriptor [result id: %s, partition id: %s, partition type: %s, subpartitions: %d, connection index: %d, is broadcast: %s, is all-to-all distribution: %s]", new Object[]{this.resultId, this.partitionId, this.partitionType, this.numberOfSubpartitions, this.connectionIndex, this.isBroadcast, this.isAllToAllDistribution});
    }

    public static PartitionDescriptor from(IntermediateResultPartition partition) {
        Preconditions.checkNotNull(partition);
        IntermediateResult result = partition.getIntermediateResult();
        return new PartitionDescriptor(result.getId(), partition.getIntermediateResult().getNumberOfAssignedPartitions(), partition.getPartitionId(), result.getResultType(), partition.getNumberOfSubpartitions(), result.getConnectionIndex(), result.isSingleSubpartitionContainsAllData(), result.getConsumingDistributionPattern() == DistributionPattern.ALL_TO_ALL, partition.isNumberOfPartitionConsumersUndefined());
    }
}

