/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.forwardgroup.StreamNodeForwardGroup;
import org.apache.flink.runtime.jobmaster.event.ExecutionJobVertexFinishedEvent;
import org.apache.flink.runtime.jobmaster.event.JobEvent;
import org.apache.flink.runtime.scheduler.adaptivebatch.AdaptiveExecutionHandler;
import org.apache.flink.runtime.scheduler.adaptivebatch.AdaptiveExecutionPlanSchedulingContext;
import org.apache.flink.runtime.scheduler.adaptivebatch.BlockingResultInfo;
import org.apache.flink.runtime.scheduler.adaptivebatch.ExecutionPlanSchedulingContext;
import org.apache.flink.runtime.scheduler.adaptivebatch.JobGraphUpdateListener;
import org.apache.flink.runtime.scheduler.adaptivebatch.OperatorsFinished;
import org.apache.flink.runtime.scheduler.adaptivebatch.StreamGraphOptimizer;
import org.apache.flink.streaming.api.graph.AdaptiveGraphManager;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.DynamicCodeLoadingException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAdaptiveExecutionHandler
implements AdaptiveExecutionHandler {
    private final Logger log = LoggerFactory.getLogger(DefaultAdaptiveExecutionHandler.class);
    private final List<JobGraphUpdateListener> jobGraphUpdateListeners = new ArrayList<JobGraphUpdateListener>();
    private final AdaptiveGraphManager adaptiveGraphManager;
    private final StreamGraphOptimizer streamGraphOptimizer;

    public DefaultAdaptiveExecutionHandler(ClassLoader userClassloader, StreamGraph streamGraph, Executor serializationExecutor) throws DynamicCodeLoadingException {
        this.adaptiveGraphManager = new AdaptiveGraphManager(userClassloader, streamGraph, serializationExecutor);
        this.streamGraphOptimizer = new StreamGraphOptimizer(streamGraph.getJobConfiguration(), userClassloader);
        this.streamGraphOptimizer.initializeStrategies(this.adaptiveGraphManager.getStreamGraphContext());
    }

    @Override
    public JobGraph getJobGraph() {
        return this.adaptiveGraphManager.getJobGraph();
    }

    @Override
    public void handleJobEvent(JobEvent jobEvent) {
        try {
            this.tryOptimizeStreamGraph(jobEvent);
            this.tryUpdateJobGraph(jobEvent);
        }
        catch (Exception e) {
            this.log.error("Failed to handle job event {}.", (Object)jobEvent, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void tryOptimizeStreamGraph(JobEvent jobEvent) throws Exception {
        if (!(jobEvent instanceof ExecutionJobVertexFinishedEvent)) {
            throw new IllegalArgumentException("Unsupported job event " + jobEvent);
        }
        ExecutionJobVertexFinishedEvent event = (ExecutionJobVertexFinishedEvent)jobEvent;
        JobVertexID vertexId = event.getVertexId();
        Map<IntermediateDataSetID, BlockingResultInfo> resultInfo = event.getResultInfo();
        Map<Integer, List<BlockingResultInfo>> resultInfoMap = resultInfo.entrySet().stream().collect(Collectors.toMap(entry -> this.adaptiveGraphManager.getProducerStreamNodeId((IntermediateDataSetID)entry.getKey()), entry -> new ArrayList<BlockingResultInfo>(Collections.singletonList((BlockingResultInfo)entry.getValue())), (existing, replacement) -> {
            existing.addAll(replacement);
            return existing;
        }));
        List<Integer> finishedStreamNodeIds = this.adaptiveGraphManager.getStreamNodeIdsByJobVertexId(vertexId);
        OperatorsFinished operatorsFinished = new OperatorsFinished(finishedStreamNodeIds, resultInfoMap);
        this.adaptiveGraphManager.addFinishedStreamNodeIds(finishedStreamNodeIds);
        this.streamGraphOptimizer.onOperatorsFinished(operatorsFinished, this.adaptiveGraphManager.getStreamGraphContext());
    }

    private void tryUpdateJobGraph(JobEvent jobEvent) throws Exception {
        ExecutionJobVertexFinishedEvent event;
        List<JobVertex> newlyCreatedJobVertices;
        if (jobEvent instanceof ExecutionJobVertexFinishedEvent && !(newlyCreatedJobVertices = this.adaptiveGraphManager.onJobVertexFinished((event = (ExecutionJobVertexFinishedEvent)jobEvent).getVertexId())).isEmpty()) {
            this.notifyJobGraphUpdated(newlyCreatedJobVertices, this.adaptiveGraphManager.getPendingOperatorsCount());
        }
    }

    private void notifyJobGraphUpdated(List<JobVertex> jobVertices, int pendingOperatorsCount) throws Exception {
        for (JobGraphUpdateListener listener : this.jobGraphUpdateListeners) {
            listener.onNewJobVerticesAdded(jobVertices, pendingOperatorsCount);
        }
    }

    @Override
    public void registerJobGraphUpdateListener(JobGraphUpdateListener listener) {
        this.jobGraphUpdateListeners.add(listener);
    }

    @Override
    public int getInitialParallelism(JobVertexID jobVertexId) {
        JobVertex jobVertex = this.adaptiveGraphManager.getJobGraph().findVertexByID(jobVertexId);
        int vertexInitialParallelism = jobVertex.getParallelism();
        StreamNodeForwardGroup forwardGroup = this.adaptiveGraphManager.getStreamNodeForwardGroupByVertexId(jobVertexId);
        if (jobVertex.getParallelism() == -1 && forwardGroup != null && forwardGroup.isParallelismDecided()) {
            vertexInitialParallelism = forwardGroup.getParallelism();
            this.log.info("Parallelism of JobVertex: {} ({}) is decided to be {} according to forward group's parallelism.", new Object[]{jobVertex.getName(), jobVertexId, vertexInitialParallelism});
        }
        return vertexInitialParallelism;
    }

    @Override
    public void notifyJobVertexParallelismDecided(JobVertexID jobVertexId, int parallelism) {
        StreamNodeForwardGroup forwardGroup = this.adaptiveGraphManager.getStreamNodeForwardGroupByVertexId(jobVertexId);
        if (forwardGroup != null && !forwardGroup.isParallelismDecided()) {
            forwardGroup.setParallelism(parallelism);
        } else if (forwardGroup != null) {
            Preconditions.checkArgument(forwardGroup.getParallelism() == parallelism, "Incompatible parallelism for forward group.");
        }
    }

    @Override
    public ExecutionPlanSchedulingContext createExecutionPlanSchedulingContext(int defaultMaxParallelism) {
        return new AdaptiveExecutionPlanSchedulingContext(this.adaptiveGraphManager, defaultMaxParallelism);
    }
}

