/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.time.Duration;
import java.util.function.Consumer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkCheckerImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.SlotSharingExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.strategy.PipelinedRegionSchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyFactory;
import org.apache.flink.runtime.util.SlotSelectionStrategyUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.SystemClock;

public class DefaultSchedulerComponents {
    private final SchedulingStrategyFactory schedulingStrategyFactory;
    private final Consumer<ComponentMainThreadExecutor> startUpAction;
    private final ExecutionSlotAllocatorFactory allocatorFactory;

    private DefaultSchedulerComponents(SchedulingStrategyFactory schedulingStrategyFactory, Consumer<ComponentMainThreadExecutor> startUpAction, ExecutionSlotAllocatorFactory allocatorFactory) {
        this.schedulingStrategyFactory = schedulingStrategyFactory;
        this.startUpAction = startUpAction;
        this.allocatorFactory = allocatorFactory;
    }

    SchedulingStrategyFactory getSchedulingStrategyFactory() {
        return this.schedulingStrategyFactory;
    }

    Consumer<ComponentMainThreadExecutor> getStartUpAction() {
        return this.startUpAction;
    }

    ExecutionSlotAllocatorFactory getAllocatorFactory() {
        return this.allocatorFactory;
    }

    static DefaultSchedulerComponents createSchedulerComponents(JobType jobType, boolean isApproximateLocalRecoveryEnabled, Configuration jobMasterConfiguration, SlotPool slotPool, Duration slotRequestTimeout) {
        Preconditions.checkArgument(!isApproximateLocalRecoveryEnabled, "Approximate local recovery can not be used together with PipelinedRegionScheduler for now! ");
        return DefaultSchedulerComponents.createPipelinedRegionSchedulerComponents(jobType, jobMasterConfiguration, slotPool, slotRequestTimeout);
    }

    private static DefaultSchedulerComponents createPipelinedRegionSchedulerComponents(JobType jobType, Configuration jobMasterConfiguration, SlotPool slotPool, Duration slotRequestTimeout) {
        SlotSelectionStrategy slotSelectionStrategy = SlotSelectionStrategyUtils.selectSlotSelectionStrategy(jobType, jobMasterConfiguration);
        PhysicalSlotRequestBulkCheckerImpl bulkChecker = PhysicalSlotRequestBulkCheckerImpl.createFromSlotPool(slotPool, SystemClock.getInstance());
        PhysicalSlotProviderImpl physicalSlotProvider = new PhysicalSlotProviderImpl(slotSelectionStrategy, slotPool);
        SlotSharingExecutionSlotAllocatorFactory allocatorFactory = new SlotSharingExecutionSlotAllocatorFactory(physicalSlotProvider, jobType == JobType.STREAMING, bulkChecker, slotRequestTimeout);
        return new DefaultSchedulerComponents(new PipelinedRegionSchedulingStrategy.Factory(), bulkChecker::start, allocatorFactory);
    }
}

