/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.AbstractAccessExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexDetailsInfo;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.OnlyExecutionGraphJsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobVertexDetailsHandler
extends AbstractAccessExecutionGraphHandler<JobVertexDetailsInfo, JobVertexMessageParameters>
implements OnlyExecutionGraphJsonArchivist {
    private final MetricFetcher metricFetcher;

    public JobVertexDetailsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobVertexDetailsInfo, JobVertexMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, MetricFetcher metricFetcher) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.metricFetcher = metricFetcher;
    }

    @Override
    protected JobVertexDetailsInfo handleRequest(HandlerRequest<EmptyRequestBody> request, AccessExecutionGraph executionGraph) throws NotFoundException {
        JobID jobID = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID jobVertexID = (JobVertexID)request.getPathParameter(JobVertexIdPathParameter.class);
        AccessExecutionJobVertex jobVertex = executionGraph.getJobVertex(jobVertexID);
        if (jobVertex == null) {
            throw new NotFoundException(String.format("JobVertex %s not found", jobVertexID));
        }
        return JobVertexDetailsHandler.createJobVertexDetailsInfo(jobVertex, jobID, this.metricFetcher);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        Collection<? extends AccessExecutionJobVertex> vertices = graph.getAllVertices().values();
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(vertices.size());
        for (AccessExecutionJobVertex accessExecutionJobVertex : vertices) {
            JobVertexDetailsInfo json = JobVertexDetailsHandler.createJobVertexDetailsInfo(accessExecutionJobVertex, graph.getJobID(), null);
            String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString());
            archive.add(new ArchivedJson(path, json));
        }
        return archive;
    }

    private static JobVertexDetailsInfo createJobVertexDetailsInfo(AccessExecutionJobVertex jobVertex, JobID jobID, @Nullable MetricFetcher metricFetcher) {
        ArrayList<SubtaskExecutionAttemptDetailsInfo> subtasks = new ArrayList<SubtaskExecutionAttemptDetailsInfo>();
        long now = System.currentTimeMillis();
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            AccessExecution execution = vertex.getCurrentExecutionAttempt();
            JobVertexID jobVertexID = jobVertex.getJobVertexId();
            Collection attempts = vertex.getCurrentExecutions();
            ArrayList<SubtaskExecutionAttemptDetailsInfo> otherConcurrentAttempts = null;
            if (attempts.size() > 1) {
                otherConcurrentAttempts = new ArrayList<SubtaskExecutionAttemptDetailsInfo>();
                for (AccessExecution attempt : attempts) {
                    if (attempt.getAttemptNumber() == execution.getAttemptNumber()) continue;
                    otherConcurrentAttempts.add(SubtaskExecutionAttemptDetailsInfo.create(attempt, metricFetcher, jobID, jobVertexID, null));
                }
            }
            subtasks.add(SubtaskExecutionAttemptDetailsInfo.create(execution, metricFetcher, jobID, jobVertexID, otherConcurrentAttempts));
        }
        return new JobVertexDetailsInfo(jobVertex.getJobVertexId(), jobVertex.getName(), jobVertex.getParallelism(), jobVertex.getMaxParallelism(), now, subtasks);
    }
}

