/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFile;
import org.apache.flink.shaded.guava32.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FatalExitExceptionHandler;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class SegmentPartitionFileWriter
implements PartitionFileWriter {
    private final ExecutorService ioExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Segment partition file flush thread").setUncaughtExceptionHandler(FatalExitExceptionHandler.INSTANCE).build());
    private final String basePath;
    private final WritableByteChannel[] subpartitionChannels;
    private volatile boolean isReleased;

    SegmentPartitionFileWriter(String basePath, int numSubpartitions) {
        this.basePath = basePath;
        this.subpartitionChannels = new WritableByteChannel[numSubpartitions];
        Arrays.fill(this.subpartitionChannels, null);
    }

    @Override
    public CompletableFuture<Void> write(TieredStoragePartitionId partitionId, List<PartitionFileWriter.SubpartitionBufferContext> buffersToWrite) {
        ArrayList completableFutures = new ArrayList();
        buffersToWrite.forEach(subpartitionBuffers -> {
            int subpartitionId = subpartitionBuffers.getSubpartitionId();
            List<PartitionFileWriter.SegmentBufferContext> segmentBufferContexts = subpartitionBuffers.getSegmentBufferContexts();
            segmentBufferContexts.forEach(segmentBufferContext -> {
                CompletableFuture flushSuccessNotifier = new CompletableFuture();
                this.ioExecutor.execute(() -> this.flushOrFinishSegment(partitionId, subpartitionId, (PartitionFileWriter.SegmentBufferContext)segmentBufferContext, flushSuccessNotifier));
                completableFutures.add(flushSuccessNotifier);
            });
        });
        return FutureUtils.waitForAll(completableFutures);
    }

    @Override
    public void release() {
        if (this.isReleased) {
            return;
        }
        this.isReleased = true;
        try {
            this.ioExecutor.shutdown();
            if (!this.ioExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                throw new TimeoutException("Timeout to shutdown the flush thread.");
            }
            for (WritableByteChannel writeChannel : this.subpartitionChannels) {
                if (writeChannel == null) continue;
                writeChannel.close();
            }
        }
        catch (Exception e) {
            ExceptionUtils.rethrow(e);
        }
    }

    private void flushOrFinishSegment(TieredStoragePartitionId partitionId, int subpartitionId, PartitionFileWriter.SegmentBufferContext segmentBufferContext, CompletableFuture<Void> flushSuccessNotifier) {
        int segmentId = segmentBufferContext.getSegmentId();
        List<Tuple2<Buffer, Integer>> buffersToFlush = segmentBufferContext.getBufferAndIndexes();
        boolean isSegmentFinished = segmentBufferContext.isSegmentFinished();
        Preconditions.checkState(!buffersToFlush.isEmpty() || isSegmentFinished);
        if (buffersToFlush.size() > 0) {
            this.flush(partitionId, subpartitionId, segmentId, buffersToFlush);
        }
        if (isSegmentFinished) {
            this.writeSegmentFinishFile(partitionId, subpartitionId, segmentId);
        }
        flushSuccessNotifier.complete(null);
    }

    private void flush(TieredStoragePartitionId partitionId, int subpartitionId, int segmentId, List<Tuple2<Buffer, Integer>> buffersToFlush) {
        try {
            this.writeBuffers(partitionId, subpartitionId, segmentId, buffersToFlush, this.getTotalBytes(buffersToFlush));
            buffersToFlush.forEach(bufferToFlush -> ((Buffer)bufferToFlush.f0).recycleBuffer());
        }
        catch (IOException exception) {
            ExceptionUtils.rethrow(exception);
        }
    }

    private void writeSegmentFinishFile(TieredStoragePartitionId partitionId, int subpartitionId, int segmentId) {
        try {
            WritableByteChannel channel = this.subpartitionChannels[subpartitionId];
            if (channel != null) {
                channel.close();
                this.subpartitionChannels[subpartitionId] = null;
            }
            SegmentPartitionFile.writeSegmentFinishFile(this.basePath, partitionId, subpartitionId, segmentId);
        }
        catch (IOException exception) {
            ExceptionUtils.rethrow(exception);
        }
    }

    private long getTotalBytes(List<Tuple2<Buffer, Integer>> buffersToFlush) {
        long expectedBytes = 0L;
        for (Tuple2<Buffer, Integer> bufferToFlush : buffersToFlush) {
            Buffer buffer = (Buffer)bufferToFlush.f0;
            int numBytes = buffer.readableBytes() + 8;
            expectedBytes += (long)numBytes;
        }
        return expectedBytes;
    }

    private void writeBuffers(TieredStoragePartitionId partitionId, int subpartitionId, int segmentId, List<Tuple2<Buffer, Integer>> buffersToFlush, long expectedBytes) throws IOException {
        WritableByteChannel currentChannel = this.getOrInitSubpartitionChannel(partitionId, subpartitionId, segmentId);
        SegmentPartitionFile.writeBuffers(currentChannel, expectedBytes, TieredStorageUtils.generateBufferWithHeaders(buffersToFlush));
    }

    private WritableByteChannel getOrInitSubpartitionChannel(TieredStoragePartitionId partitionId, int subpartitionId, int segmentId) throws IOException {
        WritableByteChannel currentChannel = this.subpartitionChannels[subpartitionId];
        if (currentChannel == null) {
            Path writingSegmentPath = SegmentPartitionFile.getSegmentPath(this.basePath, partitionId, subpartitionId, segmentId);
            FileSystem fs = writingSegmentPath.getFileSystem();
            this.subpartitionChannels[subpartitionId] = currentChannel = Channels.newChannel(fs.create(writingSegmentPath, FileSystem.WriteMode.NO_OVERWRITE));
        }
        return currentChannel;
    }
}

