/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.netty.ByteBufUtils;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyMessageDecoder;
import org.apache.flink.runtime.io.network.netty.NetworkBufferAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.util.Preconditions;

class BufferResponseDecoder
extends NettyMessageDecoder {
    private final NetworkBufferAllocator allocator;
    private ByteBuf messageHeaderBuffer;
    private List<Byte> partialSizeBytes;
    @Nullable
    private NettyMessage.BufferResponse bufferResponse;
    private int decodedDataBufferSize;

    BufferResponseDecoder(NetworkBufferAllocator allocator) {
        this.allocator = Preconditions.checkNotNull(allocator);
    }

    @Override
    public void onChannelActive(ChannelHandlerContext ctx) {
        this.messageHeaderBuffer = ctx.alloc().directBuffer(NettyMessage.BufferResponse.MESSAGE_HEADER_LENGTH);
    }

    @Override
    public NettyMessageDecoder.DecodingResult onChannelRead(ByteBuf data) throws Exception {
        if (this.bufferResponse == null) {
            this.decodeMessageHeader(data);
        }
        if (this.bufferResponse != null) {
            int remainingBufferSize = this.bufferResponse.bufferSize - this.decodedDataBufferSize;
            this.decodePartialBufferSizes(data);
            int actualBytesToDecode = Math.min(data.readableBytes(), remainingBufferSize);
            if (actualBytesToDecode > 0) {
                if (this.bufferResponse.getBuffer() == null) {
                    data.readerIndex(data.readerIndex() + actualBytesToDecode);
                } else {
                    this.bufferResponse.getBuffer().asByteBuf().writeBytes(data, actualBytesToDecode);
                }
                this.decodedDataBufferSize += actualBytesToDecode;
            }
            if (this.decodedDataBufferSize == this.bufferResponse.bufferSize) {
                NettyMessage.BufferResponse result = this.bufferResponse;
                this.clearState();
                return NettyMessageDecoder.DecodingResult.fullMessage(result);
            }
        }
        return NettyMessageDecoder.DecodingResult.NOT_FINISHED;
    }

    private void decodePartialBufferSizes(ByteBuf data) {
        if (this.bufferResponse.numOfPartialBuffers > 0 && this.bufferResponse.getPartialBufferSizes().size() < this.bufferResponse.numOfPartialBuffers) {
            this.accumulatePartialSizeBytes(data);
            this.readRemainingBufferSizes(data);
        }
    }

    private void accumulatePartialSizeBytes(ByteBuf data) {
        if (this.partialSizeBytes != null) {
            while (this.partialSizeBytes.size() < 4 && data.isReadable()) {
                this.partialSizeBytes.add(data.readByte());
            }
            if (this.partialSizeBytes.size() == 4) {
                int size = this.buildIntFromBytes(this.partialSizeBytes);
                this.bufferResponse.getPartialBufferSizes().add(size);
                this.partialSizeBytes = null;
            }
        }
    }

    private void readRemainingBufferSizes(ByteBuf data) {
        while (data.isReadable() && this.bufferResponse.getPartialBufferSizes().size() < this.bufferResponse.numOfPartialBuffers) {
            if (data.readableBytes() >= 4) {
                this.bufferResponse.getPartialBufferSizes().add(data.readInt());
                continue;
            }
            this.partialSizeBytes = new ArrayList<Byte>();
            while (data.isReadable()) {
                this.partialSizeBytes.add(data.readByte());
            }
        }
    }

    private int buildIntFromBytes(List<Byte> byteList) {
        Preconditions.checkState(byteList.size() == 4);
        return (byteList.get(0) & 0xFF) << 24 | (byteList.get(1) & 0xFF) << 16 | (byteList.get(2) & 0xFF) << 8 | byteList.get(3) & 0xFF;
    }

    private void decodeMessageHeader(ByteBuf data) {
        ByteBuf fullFrameHeaderBuf = ByteBufUtils.accumulate(this.messageHeaderBuffer, data, NettyMessage.BufferResponse.MESSAGE_HEADER_LENGTH, this.messageHeaderBuffer.readableBytes());
        if (fullFrameHeaderBuf != null) {
            this.bufferResponse = NettyMessage.BufferResponse.readFrom(fullFrameHeaderBuf, this.allocator);
        }
    }

    private void clearState() {
        this.bufferResponse = null;
        this.decodedDataBufferSize = 0;
        this.messageHeaderBuffer.clear();
    }

    @Override
    public void close() {
        if (this.bufferResponse != null) {
            this.bufferResponse.releaseBuffer();
        }
        this.messageHeaderBuffer.release();
    }
}

