/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfData;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.consumer.EndOfChannelStateEvent;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.util.Preconditions;

public interface Buffer {
    public boolean isBuffer();

    @Deprecated
    public MemorySegment getMemorySegment();

    @Deprecated
    public int getMemorySegmentOffset();

    public BufferRecycler getRecycler();

    public void setRecycler(BufferRecycler var1);

    public void recycleBuffer();

    public boolean isRecycled();

    public Buffer retainBuffer();

    public Buffer readOnlySlice();

    public Buffer readOnlySlice(int var1, int var2);

    public int getMaxCapacity();

    public int getReaderIndex();

    public void setReaderIndex(int var1) throws IndexOutOfBoundsException;

    public int getSize();

    public void setSize(int var1);

    public int readableBytes();

    public ByteBuffer getNioBufferReadable();

    public ByteBuffer getNioBuffer(int var1, int var2) throws IndexOutOfBoundsException;

    public void setAllocator(ByteBufAllocator var1);

    public ByteBuf asByteBuf();

    public boolean isCompressed();

    public void setCompressed(boolean var1);

    public DataType getDataType();

    public void setDataType(DataType var1);

    public int refCnt();

    default public String toDebugString(boolean includeHash) {
        StringBuilder prettyString = new StringBuilder("Buffer{cnt=").append(this.refCnt()).append(", size=").append(this.getSize());
        if (includeHash) {
            byte[] bytes = new byte[this.getSize()];
            this.readOnlySlice().asByteBuf().readBytes(bytes);
            prettyString.append(", hash=").append(Arrays.hashCode(bytes));
        }
        return prettyString.append("}").toString();
    }

    public static enum DataType {
        NONE(false, false, false, false, false, false),
        DATA_BUFFER(true, false, false, false, false, true),
        EVENT_BUFFER(false, true, false, false, false, false),
        PRIORITIZED_EVENT_BUFFER(false, true, false, true, false, false),
        ALIGNED_CHECKPOINT_BARRIER(false, true, true, false, false, false),
        TIMEOUTABLE_ALIGNED_CHECKPOINT_BARRIER(false, true, true, false, true, false),
        RECOVERY_COMPLETION(false, true, true, false, false, false),
        END_OF_SEGMENT(false, true, false, false, false, false),
        DATA_BUFFER_WITH_CLEAR_END(true, false, false, false, false, false),
        END_OF_DATA(false, true, false, false, false, false),
        END_OF_PARTITION(false, true, false, false, false, false),
        RECOVERY_METADATA(false, true, false, false, false, false),
        ALIGNED_WATERMARK_EVENT(false, true, true, false, false, false),
        UNALIGNED_WATERMARK_EVENT(false, true, false, false, false, false);

        private final boolean isBuffer;
        private final boolean isEvent;
        private final boolean isBlockingUpstream;
        private final boolean hasPriority;
        private final boolean requiresAnnouncement;
        private final boolean isPartialRecord;

        private DataType(boolean isBuffer, boolean isEvent, boolean isBlockingUpstream, boolean hasPriority, boolean requiresAnnouncement, boolean isPartialRecord) {
            Preconditions.checkState(!requiresAnnouncement || !hasPriority, "DataType [%s] has both priority and requires announcement, which is not supported and doesn't make sense. There should be no need for announcing priority events, which are always overtaking in-flight data.", new Object[]{this});
            this.isBuffer = isBuffer;
            this.isEvent = isEvent;
            this.isBlockingUpstream = isBlockingUpstream;
            this.hasPriority = hasPriority;
            this.requiresAnnouncement = requiresAnnouncement;
            this.isPartialRecord = isPartialRecord;
        }

        public boolean isBuffer() {
            return this.isBuffer;
        }

        public boolean isEvent() {
            return this.isEvent;
        }

        public boolean hasPriority() {
            return this.hasPriority;
        }

        public boolean isBlockingUpstream() {
            return this.isBlockingUpstream;
        }

        public boolean requiresAnnouncement() {
            return this.requiresAnnouncement;
        }

        public boolean isPartialRecord() {
            return this.isPartialRecord;
        }

        public static DataType getDataType(AbstractEvent event, boolean hasPriority) {
            if (hasPriority) {
                return PRIORITIZED_EVENT_BUFFER;
            }
            if (event instanceof EndOfChannelStateEvent) {
                return RECOVERY_COMPLETION;
            }
            if (event instanceof EndOfData) {
                return END_OF_DATA;
            }
            if (event instanceof EndOfPartitionEvent) {
                return END_OF_PARTITION;
            }
            if (event instanceof WatermarkEvent) {
                if (((WatermarkEvent)event).isAligned()) {
                    return ALIGNED_WATERMARK_EVENT;
                }
                return UNALIGNED_WATERMARK_EVENT;
            }
            if (!(event instanceof CheckpointBarrier)) {
                return EVENT_BUFFER;
            }
            CheckpointBarrier barrier = (CheckpointBarrier)event;
            if (barrier.getCheckpointOptions().needsAlignment()) {
                if (barrier.getCheckpointOptions().isTimeoutable()) {
                    return TIMEOUTABLE_ALIGNED_CHECKPOINT_BARRIER;
                }
                return ALIGNED_CHECKPOINT_BARRIER;
            }
            return EVENT_BUFFER;
        }
    }
}

