/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.failover.ExponentialDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.FailureRateRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.FixedDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.NoRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartBackoffTimeStrategy;
import org.apache.flink.util.Preconditions;

public final class RestartBackoffTimeStrategyFactoryLoader {
    private RestartBackoffTimeStrategyFactoryLoader() {
    }

    public static RestartBackoffTimeStrategy.Factory createRestartBackoffTimeStrategyFactory(Configuration jobConfiguration, Configuration clusterConfiguration, boolean isCheckpointingEnabled) {
        Preconditions.checkNotNull(jobConfiguration);
        Preconditions.checkNotNull(clusterConfiguration);
        return RestartBackoffTimeStrategyFactoryLoader.getRestartStrategyFactoryFromConfig(jobConfiguration).orElse(RestartBackoffTimeStrategyFactoryLoader.getRestartStrategyFactoryFromConfig(clusterConfiguration).orElse(RestartBackoffTimeStrategyFactoryLoader.getDefaultRestartStrategyFactory(isCheckpointingEnabled)));
    }

    private static Optional<RestartBackoffTimeStrategy.Factory> getRestartStrategyFactoryFromConfig(Configuration configuration) {
        Optional<String> restartStrategyNameOptional = configuration.getOptional(RestartStrategyOptions.RESTART_STRATEGY);
        return restartStrategyNameOptional.map(restartStrategyName -> {
            switch (RestartStrategyOptions.RestartStrategyType.of(restartStrategyName.toLowerCase())) {
                case NO_RESTART_STRATEGY: {
                    return NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE;
                }
                case FIXED_DELAY: {
                    return FixedDelayRestartBackoffTimeStrategy.createFactory(configuration);
                }
                case FAILURE_RATE: {
                    return FailureRateRestartBackoffTimeStrategy.createFactory(configuration);
                }
                case EXPONENTIAL_DELAY: {
                    return ExponentialDelayRestartBackoffTimeStrategy.createFactory(configuration);
                }
            }
            throw new IllegalArgumentException("Unknown restart strategy " + restartStrategyName + ".");
        });
    }

    private static RestartBackoffTimeStrategy.Factory getDefaultRestartStrategyFactory(boolean isCheckpointingEnabled) {
        if (isCheckpointingEnabled) {
            return new ExponentialDelayRestartBackoffTimeStrategy.ExponentialDelayRestartBackoffTimeStrategyFactory(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF.defaultValue().toMillis(), RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF.defaultValue().toMillis(), RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER.defaultValue(), RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD.defaultValue().toMillis(), RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR.defaultValue(), RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_ATTEMPTS.defaultValue());
        }
        return NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE;
    }
}

