/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.util.Preconditions;

public class ResultPartitionBytes
implements Serializable {
    private final long[] subpartitionBytes;

    public ResultPartitionBytes(long[] subpartitionBytes) {
        this.subpartitionBytes = Preconditions.checkNotNull(subpartitionBytes);
    }

    public long[] getSubpartitionBytes() {
        return this.subpartitionBytes;
    }

    public static ResultPartitionBytes mergeAll(List<ResultPartitionBytes> partitions) {
        Preconditions.checkArgument(!partitions.isEmpty());
        int expectedLength = partitions.get(0).getSubpartitionBytes().length;
        for (ResultPartitionBytes resultPartitionByte : partitions) {
            if (resultPartitionByte.getSubpartitionBytes().length == expectedLength) continue;
            throw new IllegalArgumentException("only all ResultPartitionBytes with the same length can be merged");
        }
        long[] mergedSubpartitionBytes = new long[expectedLength];
        for (int i = 0; i < expectedLength; ++i) {
            for (ResultPartitionBytes resultPartitionByte : partitions) {
                int n = i;
                mergedSubpartitionBytes[n] = mergedSubpartitionBytes[n] + resultPartitionByte.getSubpartitionBytes()[i];
            }
        }
        return new ResultPartitionBytes(mergedSubpartitionBytes);
    }
}

