/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.handler.job.JobSubmitHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.webmonitor.WebMonitorEndpoint;
import org.apache.flink.runtime.webmonitor.WebMonitorExtension;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;

public class DispatcherRestEndpoint
extends WebMonitorEndpoint<DispatcherGateway> {
    private WebMonitorExtension webSubmissionExtension = WebMonitorExtension.empty();

    public DispatcherRestEndpoint(GatewayRetriever<DispatcherGateway> leaderRetriever, Configuration clusterConfiguration, RestHandlerConfiguration restConfiguration, GatewayRetriever<ResourceManagerGateway> resourceManagerRetriever, TransientBlobService transientBlobService, ScheduledExecutorService executor, MetricFetcher metricFetcher, LeaderElection leaderElection, ExecutionGraphCache executionGraphCache, FatalErrorHandler fatalErrorHandler) throws IOException, ConfigurationException {
        super(leaderRetriever, clusterConfiguration, restConfiguration, resourceManagerRetriever, transientBlobService, executor, metricFetcher, leaderElection, executionGraphCache, fatalErrorHandler);
    }

    @Override
    protected List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> localAddressFuture) {
        List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers = super.initializeHandlers(localAddressFuture);
        Duration timeout = this.restConfiguration.getTimeout();
        JobSubmitHandler jobSubmitHandler = new JobSubmitHandler(this.leaderRetriever, timeout, this.responseHeaders, this.executor, this.clusterConfiguration);
        handlers.add(Tuple2.of(jobSubmitHandler.getMessageHeaders(), jobSubmitHandler));
        return handlers;
    }

    @Override
    protected Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeWebSubmissionHandlers(CompletableFuture<String> localAddressFuture) {
        if (this.restConfiguration.isWebSubmitEnabled()) {
            try {
                Duration timeout = this.restConfiguration.getTimeout();
                this.webSubmissionExtension = WebMonitorUtils.loadWebSubmissionExtension(this.leaderRetriever, timeout, this.responseHeaders, localAddressFuture, this.uploadDir, this.executor, this.clusterConfiguration);
                return this.webSubmissionExtension.getHandlers();
            }
            catch (FlinkException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to load web based job submission extension.", (Throwable)e);
                }
                this.log.info("Failed to load web based job submission extension. Probable reason: flink-runtime-web is not in the classpath.");
            }
        } else {
            this.log.info("Web-based job submission is not enabled.");
        }
        return Collections.emptyList();
    }

    @Override
    protected CompletableFuture<Void> shutDownInternal() {
        CompletableFuture<Void> shutdownFuture = super.shutDownInternal();
        CompletableFuture<Void> shutdownResultFuture = new CompletableFuture<Void>();
        shutdownFuture.whenComplete((ignored, throwable) -> this.webSubmissionExtension.closeAsync().whenComplete((innerIgnored, innerThrowable) -> {
            if (innerThrowable != null) {
                shutdownResultFuture.completeExceptionally(ExceptionUtils.firstOrSuppressed(innerThrowable, throwable));
            } else if (throwable != null) {
                shutdownResultFuture.completeExceptionally((Throwable)throwable);
            } else {
                shutdownResultFuture.complete(null);
            }
        }));
        return shutdownResultFuture;
    }
}

