/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.util.IntArrayList;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class RescaleMappings
implements Serializable {
    public static final RescaleMappings SYMMETRIC_IDENTITY = RescaleMappings.identity(Integer.MAX_VALUE, Integer.MAX_VALUE);
    static final int[] EMPTY_TARGETS = new int[0];
    private static final long serialVersionUID = -8719670050630674631L;
    private final int numberOfSources;
    private final int[][] mappings;
    private final int numberOfTargets;

    RescaleMappings(int numberOfSources, int[][] mappings, int numberOfTargets) {
        this.numberOfSources = numberOfSources;
        this.mappings = Preconditions.checkNotNull(mappings);
        this.numberOfTargets = numberOfTargets;
    }

    public static RescaleMappings identity(int numberOfSources, int numberOfTargets) {
        return new IdentityRescaleMappings(numberOfSources, numberOfTargets);
    }

    public boolean isIdentity() {
        return false;
    }

    public int[] getMappedIndexes(int sourceIndex) {
        if (sourceIndex >= this.mappings.length) {
            return EMPTY_TARGETS;
        }
        return this.mappings[sourceIndex];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RescaleMappings that = (RescaleMappings)o;
        return Arrays.deepEquals((Object[])this.mappings, (Object[])that.mappings);
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.mappings);
    }

    public String toString() {
        return "RescaleMappings{mappings=" + Arrays.deepToString((Object[])this.mappings) + "}";
    }

    public RescaleMappings invert() {
        IntArrayList[] inverted = new IntArrayList[this.numberOfTargets];
        for (int source = 0; source < this.mappings.length; ++source) {
            int[] targets;
            for (int target : targets = this.mappings[source]) {
                IntArrayList sources = inverted[target];
                if (sources == null) {
                    inverted[target] = sources = new IntArrayList(1);
                }
                sources.add(source);
            }
        }
        return RescaleMappings.of(Arrays.stream(inverted).map(RescaleMappings::toSortedArray), this.numberOfSources);
    }

    public Set<Integer> getAmbiguousTargets() {
        HashSet<Integer> ambiguousTargets = CollectionUtil.newHashSetWithExpectedSize(this.numberOfTargets);
        BitSet usedTargets = new BitSet(this.numberOfTargets);
        int[][] nArray = this.mappings;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] targets;
            for (int target : targets = nArray[i]) {
                if (usedTargets.get(target)) {
                    ambiguousTargets.add(target);
                    continue;
                }
                usedTargets.set(target);
            }
        }
        return ambiguousTargets;
    }

    public static RescaleMappings of(Stream<int[]> mappedTargets, int numberOfTargets) {
        int lastNonEmpty;
        int[][] mappings = (int[][])mappedTargets.map(targets -> ((int[])targets).length == 0 ? EMPTY_TARGETS : targets).toArray(x$0 -> new int[x$0][]);
        if (RescaleMappings.isIdentity(mappings, numberOfTargets)) {
            return new IdentityRescaleMappings(mappings.length, numberOfTargets);
        }
        for (lastNonEmpty = mappings.length - 1; lastNonEmpty >= 0 && mappings[lastNonEmpty] == EMPTY_TARGETS; --lastNonEmpty) {
        }
        int length = lastNonEmpty + 1;
        return new RescaleMappings(mappings.length, length == mappings.length ? mappings : (int[][])Arrays.copyOf(mappings, length), numberOfTargets);
    }

    private static boolean isIdentity(int[][] mappings, int numberOfTargets) {
        int source;
        if (mappings.length < numberOfTargets) {
            return false;
        }
        for (source = numberOfTargets; source < mappings.length; ++source) {
            if (mappings[source] == EMPTY_TARGETS) continue;
            return false;
        }
        for (source = 0; source < numberOfTargets; ++source) {
            if (mappings[source].length == 1 && source == mappings[source][0]) continue;
            return false;
        }
        return true;
    }

    private static int[] toSortedArray(IntArrayList sourceList) {
        if (sourceList == null) {
            return EMPTY_TARGETS;
        }
        int[] sources = sourceList.toArray();
        Arrays.sort(sources);
        return sources;
    }

    @VisibleForTesting
    int getNumberOfSources() {
        return this.numberOfSources;
    }

    @VisibleForTesting
    int getNumberOfTargets() {
        return this.numberOfTargets;
    }

    @VisibleForTesting
    int[][] getMappings() {
        return this.mappings;
    }

    private static final class IdentityRescaleMappings
    extends RescaleMappings {
        public static final int[][] IMPLICIT_MAPPING = new int[0][0];
        private static final long serialVersionUID = -4406023794753660925L;

        public IdentityRescaleMappings(int numberOfSources, int numberOfTargets) {
            super(numberOfSources, IMPLICIT_MAPPING, numberOfTargets);
        }

        @Override
        public int[] getMappedIndexes(int sourceIndex) {
            if (sourceIndex >= this.getNumberOfTargets()) {
                return EMPTY_TARGETS;
            }
            return new int[]{sourceIndex};
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public Set<Integer> getAmbiguousTargets() {
            return Collections.emptySet();
        }

        @Override
        public RescaleMappings invert() {
            return new IdentityRescaleMappings(this.getNumberOfTargets(), this.getNumberOfSources());
        }

        @Override
        public String toString() {
            return "IdentityRescaleMappings{" + this.getNumberOfSources() + "->" + this.getAmbiguousTargets() + "}";
        }
    }
}

