/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFileMigrationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationFileMigrationUtils.class);
    @VisibleForTesting
    public static final String LEGACY_FLINK_CONF_FILENAME = "flink-conf.yaml";

    public static Configuration migrateLegacyToStandardYamlConfig(String configDir) {
        if (configDir == null) {
            throw new IllegalArgumentException("Given configuration directory is null, cannot load configuration");
        }
        File confDirFile = new File(configDir);
        if (!confDirFile.exists()) {
            throw new IllegalConfigurationException("The given configuration directory name '" + configDir + "' (" + confDirFile.getAbsolutePath() + ") does not describe an existing directory.");
        }
        File yamlConfigFile = new File(confDirFile, LEGACY_FLINK_CONF_FILENAME);
        if (!yamlConfigFile.exists()) {
            throw new IllegalConfigurationException("The Flink config file '" + yamlConfigFile + "' (" + yamlConfigFile.getAbsolutePath() + ") does not exist.");
        }
        LOG.info("Using legacy YAML parser to load flink configuration file from {}.", (Object)yamlConfigFile.getAbsolutePath());
        Map<String, String> configuration = ConfigurationFileMigrationUtils.loadLegacyYAMLResource(yamlConfigFile);
        Configuration standardYamlConfig = new Configuration();
        configuration.forEach(standardYamlConfig::setString);
        return standardYamlConfig;
    }

    @VisibleForTesting
    public static Map<String, String> loadLegacyYAMLResource(File file) {
        HashMap<String, String> config = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNo;
                String[] comments = line.split("#", 2);
                String conf = comments[0].trim();
                if (conf.length() <= 0) continue;
                String[] kv = conf.split(": ", 2);
                if (kv.length == 1) {
                    LOG.warn("Error while trying to split key and value in configuration file " + file + ":" + lineNo + ": Line is not a key-value pair (missing space after ':'?)");
                    continue;
                }
                String key = kv[0].trim();
                String value = kv[1].trim();
                if (key.length() == 0 || value.length() == 0) {
                    LOG.warn("Error after splitting key and value in configuration file " + file + ":" + lineNo + ": Key or value was empty");
                    continue;
                }
                config.put(key, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing YAML configuration.", e);
        }
        return config;
    }
}

