/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state.v2;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Experimental
public class AggregatingStateDescriptor<IN, ACC, OUT>
extends StateDescriptor<ACC> {
    private final AggregateFunction<IN, ACC, OUT> aggregateFunction;

    public AggregatingStateDescriptor(@Nonnull String stateId, @Nonnull AggregateFunction<IN, ACC, OUT> aggregateFunction, @Nonnull TypeInformation<ACC> typeInfo) {
        super(stateId, typeInfo);
        this.aggregateFunction = Preconditions.checkNotNull(aggregateFunction);
    }

    public AggregatingStateDescriptor(@Nonnull String stateId, @Nonnull AggregateFunction<IN, ACC, OUT> aggregateFunction, @Nonnull TypeSerializer<ACC> serializer) {
        super(stateId, serializer);
        this.aggregateFunction = Preconditions.checkNotNull(aggregateFunction);
    }

    public AggregatingStateDescriptor(String name, AggregateFunction<IN, ACC, OUT> aggFunction, Class<ACC> stateType) {
        super(name, stateType);
        this.aggregateFunction = Preconditions.checkNotNull(aggFunction);
    }

    public AggregateFunction<IN, ACC, OUT> getAggregateFunction() {
        return this.aggregateFunction;
    }

    @Override
    public StateDescriptor.Type getType() {
        return StateDescriptor.Type.AGGREGATING;
    }
}

