/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDuplicator;
import org.apache.flink.util.Preconditions;

@Internal
public final class LogicalTypeUtils {
    private static final String ATOMIC_FIELD_NAME = "f0";
    private static final TimeAttributeRemover TIME_ATTRIBUTE_REMOVER = new TimeAttributeRemover();

    public static LogicalType removeTimeAttributes(LogicalType logicalType) {
        return logicalType.accept(TIME_ATTRIBUTE_REMOVER);
    }

    public static Class<?> toInternalConversionClass(LogicalType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return StringData.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case BINARY: 
            case VARBINARY: {
                return byte[].class;
            }
            case DECIMAL: {
                return DecimalData.class;
            }
            case TINYINT: {
                return Byte.class;
            }
            case SMALLINT: {
                return Short.class;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return Integer.class;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return TimestampData.class;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException("Unsupported type: " + type);
            }
            case ARRAY: {
                return ArrayData.class;
            }
            case MULTISET: 
            case MAP: {
                return MapData.class;
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                return RowData.class;
            }
            case DISTINCT_TYPE: {
                return LogicalTypeUtils.toInternalConversionClass(((DistinctType)type).getSourceType());
            }
            case RAW: {
                return RawValueData.class;
            }
            case NULL: {
                return Object.class;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static RowType toRowType(LogicalType t) {
        switch (t.getTypeRoot()) {
            case ROW: {
                return (RowType)t;
            }
            case STRUCTURED_TYPE: {
                StructuredType structuredType = (StructuredType)t;
                List<RowType.RowField> fields = structuredType.getAttributes().stream().map(attribute -> new RowType.RowField(attribute.getName(), attribute.getType(), attribute.getDescription().orElse(null))).collect(Collectors.toList());
                return new RowType(structuredType.isNullable(), fields);
            }
            case DISTINCT_TYPE: {
                return LogicalTypeUtils.toRowType(((DistinctType)t).getSourceType());
            }
        }
        return RowType.of(t);
    }

    public static String getAtomicName(List<String> existingNames) {
        int i = 0;
        Object fieldName = ATOMIC_FIELD_NAME;
        while (null != existingNames && existingNames.contains(fieldName)) {
            fieldName = "f0_" + i++;
        }
        return fieldName;
    }

    public static RowType renameRowFields(RowType rowType, List<String> newFieldNames) {
        Preconditions.checkArgument(rowType.getFieldCount() == newFieldNames.size(), "Row length and new names must match.");
        List<RowType.RowField> newFields = IntStream.range(0, rowType.getFieldCount()).mapToObj(pos -> {
            RowType.RowField oldField = rowType.getFields().get(pos);
            return new RowType.RowField((String)newFieldNames.get(pos), oldField.getType(), oldField.getDescription().orElse(null));
        }).collect(Collectors.toList());
        return new RowType(rowType.isNullable(), newFields);
    }

    private LogicalTypeUtils() {
    }

    private static class TimeAttributeRemover
    extends LogicalTypeDuplicator {
        private TimeAttributeRemover() {
        }

        @Override
        public LogicalType visit(TimestampType timestampType) {
            return new TimestampType(timestampType.isNullable(), timestampType.getPrecision());
        }

        @Override
        public LogicalType visit(ZonedTimestampType zonedTimestampType) {
            return new ZonedTimestampType(zonedTimestampType.isNullable(), zonedTimestampType.getPrecision());
        }

        @Override
        public LogicalType visit(LocalZonedTimestampType localZonedTimestampType) {
            return new LocalZonedTimestampType(localZonedTimestampType.isNullable(), localZonedTimestampType.getPrecision());
        }
    }
}

