/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.operations.utils.OperationExpressionsUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public class WindowAggregateQueryOperation
implements QueryOperation {
    private static final String INPUT_ALIAS = "$$T_WIN_AGG";
    private final List<ResolvedExpression> groupingExpressions;
    private final List<ResolvedExpression> aggregateExpressions;
    private final List<ResolvedExpression> windowPropertiesExpressions;
    private final ResolvedGroupWindow groupWindow;
    private final QueryOperation child;
    private final ResolvedSchema resolvedSchema;

    public WindowAggregateQueryOperation(List<ResolvedExpression> groupingExpressions, List<ResolvedExpression> aggregateExpressions, List<ResolvedExpression> windowPropertiesExpressions, ResolvedGroupWindow groupWindow, QueryOperation child, ResolvedSchema resolvedSchema) {
        this.groupingExpressions = groupingExpressions;
        this.aggregateExpressions = aggregateExpressions;
        this.windowPropertiesExpressions = windowPropertiesExpressions;
        this.groupWindow = groupWindow;
        this.child = child;
        this.resolvedSchema = resolvedSchema;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("group", this.groupingExpressions);
        args.put("agg", this.aggregateExpressions);
        args.put("windowProperties", this.windowPropertiesExpressions);
        args.put("window", this.groupWindow.asSummaryString());
        return OperationUtils.formatWithChildren("WindowAggregate", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString() {
        return String.format("SELECT %s FROM TABLE(%s\n) %s GROUP BY %s", Stream.of(this.groupingExpressions.stream(), this.aggregateExpressions.stream(), this.windowPropertiesExpressions.stream()).flatMap(Function.identity()).map(expr -> OperationExpressionsUtils.scopeReferencesWithAlias(INPUT_ALIAS, expr)).map(ResolvedExpression::asSerializableString).collect(Collectors.joining(", ")), OperationUtils.indent(this.groupWindow.asSerializableString(this.child.asSerializableString())), INPUT_ALIAS, Stream.concat(Stream.of("window_start", "window_end"), this.groupingExpressions.stream().map(expr -> OperationExpressionsUtils.scopeReferencesWithAlias(INPUT_ALIAS, expr)).map(ResolvedExpression::asSerializableString)).collect(Collectors.joining(", ")));
    }

    public List<ResolvedExpression> getGroupingExpressions() {
        return this.groupingExpressions;
    }

    public List<ResolvedExpression> getAggregateExpressions() {
        return this.aggregateExpressions;
    }

    public List<ResolvedExpression> getWindowPropertiesExpressions() {
        return this.windowPropertiesExpressions;
    }

    public ResolvedGroupWindow getGroupWindow() {
        return this.groupWindow;
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.singletonList(this.child);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Internal
    public static class ResolvedGroupWindow {
        private final WindowType type;
        private final String alias;
        private final FieldReferenceExpression timeAttribute;
        private final ValueLiteralExpression slide;
        private final ValueLiteralExpression size;
        private final ValueLiteralExpression gap;

        private ResolvedGroupWindow(WindowType type, String alias, FieldReferenceExpression timeAttribute, @Nullable ValueLiteralExpression size, @Nullable ValueLiteralExpression slide, @Nullable ValueLiteralExpression gap) {
            Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(alias));
            this.type = type;
            this.timeAttribute = Preconditions.checkNotNull(timeAttribute);
            this.alias = alias;
            this.slide = slide;
            this.size = size;
            this.gap = gap;
        }

        public static ResolvedGroupWindow slidingWindow(String alias, FieldReferenceExpression timeAttribute, ValueLiteralExpression size, ValueLiteralExpression slide) {
            Preconditions.checkNotNull(size);
            Preconditions.checkNotNull(slide);
            return new ResolvedGroupWindow(WindowType.SLIDE, alias, timeAttribute, size, slide, null);
        }

        public static ResolvedGroupWindow tumblingWindow(String alias, FieldReferenceExpression timeAttribute, ValueLiteralExpression size) {
            Preconditions.checkNotNull(size);
            return new ResolvedGroupWindow(WindowType.TUMBLE, alias, timeAttribute, size, null, null);
        }

        public static ResolvedGroupWindow sessionWindow(String alias, FieldReferenceExpression timeAttribute, ValueLiteralExpression gap) {
            Preconditions.checkNotNull(gap);
            return new ResolvedGroupWindow(WindowType.SESSION, alias, timeAttribute, null, null, gap);
        }

        public WindowType getType() {
            return this.type;
        }

        public FieldReferenceExpression getTimeAttribute() {
            return this.timeAttribute;
        }

        public String getAlias() {
            return this.alias;
        }

        public Optional<ValueLiteralExpression> getSlide() {
            return Optional.of(this.slide);
        }

        public Optional<ValueLiteralExpression> getSize() {
            return Optional.of(this.size);
        }

        public Optional<ValueLiteralExpression> getGap() {
            return Optional.of(this.gap);
        }

        public String asSummaryString() {
            switch (this.type) {
                case SLIDE: {
                    return String.format("SlideWindow(field: [%s], slide: [%s], size: [%s])", this.timeAttribute, this.slide, this.size);
                }
                case SESSION: {
                    return String.format("SessionWindow(field: [%s], gap: [%s])", this.timeAttribute, this.gap);
                }
                case TUMBLE: {
                    return String.format("TumbleWindow(field: [%s], size: [%s])", this.timeAttribute, this.size);
                }
            }
            throw new IllegalStateException("Unknown window type: " + this.type);
        }

        public String asSerializableString(String table) {
            switch (this.type) {
                case SLIDE: {
                    return String.format("HOP((%s\n), DESCRIPTOR(%s), %s, %s)", OperationUtils.indent(table), this.timeAttribute.asSerializableString(), this.slide.asSerializableString(), this.size.asSerializableString());
                }
                case SESSION: {
                    throw new TableException("Session windows are not SQL serializable yet.");
                }
                case TUMBLE: {
                    return String.format("TUMBLE((%s\n), DESCRIPTOR(%s), %s)", OperationUtils.indent(table), this.timeAttribute.asSerializableString(), this.size.asSerializableString());
                }
            }
            throw new IllegalStateException("Unknown window type: " + this.type);
        }

        @Internal
        public static enum WindowType {
            SLIDE,
            SESSION,
            TUMBLE;

        }
    }
}

