/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.context;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.PlanCacheManager;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogStoreHolder;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.gateway.api.config.SqlGatewayServiceConfigOptions;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.context.EnvironmentReusableInMemoryCatalog;
import org.apache.flink.table.gateway.service.materializedtable.MaterializedTableManager;
import org.apache.flink.table.gateway.service.operation.OperationExecutor;
import org.apache.flink.table.gateway.service.operation.OperationManager;
import org.apache.flink.table.gateway.service.utils.SqlExecutionException;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.MutableURLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionContext {
    private static final Logger LOG = LoggerFactory.getLogger(SessionContext.class);
    private final DefaultContext defaultContext;
    private final SessionHandle sessionId;
    private final EndpointVersion endpointVersion;
    private final Configuration sessionConf;
    private final SessionState sessionState;
    private final URLClassLoader userClassloader;
    private final OperationManager operationManager;
    private boolean isStatementSetState;
    private final List<ModifyOperation> statementSetOperations;
    @Nullable
    private final PlanCacheManager planCacheManager;

    protected SessionContext(DefaultContext defaultContext, SessionHandle sessionId, EndpointVersion endpointVersion, Configuration sessionConf, URLClassLoader classLoader, SessionState sessionState, OperationManager operationManager) {
        this.defaultContext = defaultContext;
        this.sessionId = sessionId;
        this.endpointVersion = endpointVersion;
        this.sessionConf = sessionConf;
        this.userClassloader = classLoader;
        this.sessionState = sessionState;
        this.operationManager = operationManager;
        this.isStatementSetState = false;
        this.statementSetOperations = new ArrayList<ModifyOperation>();
        this.planCacheManager = SessionContext.createPlanCacheManager(sessionConf);
    }

    @Nullable
    private static PlanCacheManager createPlanCacheManager(ReadableConfig readableConfig) {
        boolean planCacheEnabled = readableConfig.get(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_PLAN_CACHE_ENABLED);
        if (planCacheEnabled) {
            int planCacheSize = readableConfig.get(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_PLAN_CACHE_SIZE);
            Duration ttl = readableConfig.get(SqlGatewayServiceConfigOptions.SQL_GATEWAY_SESSION_PLAN_CACHE_TTL);
            return new PlanCacheManager(planCacheSize, ttl);
        }
        return null;
    }

    public SessionHandle getSessionId() {
        return this.sessionId;
    }

    public Configuration getSessionConf() {
        return new UnmodifiableConfiguration(this.sessionConf);
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    public EndpointVersion getEndpointVersion() {
        return this.endpointVersion;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public URLClassLoader getUserClassloader() {
        return this.userClassloader;
    }

    @Nullable
    public PlanCacheManager getPlanCacheManager() {
        return this.planCacheManager;
    }

    public void set(String key, String value) {
        try {
            this.createOperationExecutor(Configuration.fromMap(Collections.singletonMap(key, value))).getTableEnvironment();
        }
        catch (Exception e) {
            throw new SqlExecutionException(String.format("Failed to set key %s with value %s.", key, value), e);
        }
        this.sessionConf.setString(key, value);
        this.invalidatePlanCacheIfExist();
    }

    public synchronized void reset(String key) {
        ConfigOption<String> option;
        Configuration configuration = this.defaultContext.getFlinkConfig();
        if (configuration.contains(option = ConfigOptions.key(key).stringType().noDefaultValue())) {
            String defaultValue = configuration.get(option);
            this.set(key, defaultValue);
        } else {
            this.sessionConf.removeConfig(option);
        }
        this.invalidatePlanCacheIfExist();
    }

    public synchronized void reset() {
        for (String key : this.sessionConf.keySet()) {
            this.sessionConf.removeConfig(ConfigOptions.key(key).stringType().noDefaultValue());
        }
        this.sessionConf.addAll(this.defaultContext.getFlinkConfig());
        this.invalidatePlanCacheIfExist();
    }

    public OperationExecutor createOperationExecutor(Configuration executionConfig) {
        return new OperationExecutor(this, executionConfig);
    }

    private void invalidatePlanCacheIfExist() {
        if (this.planCacheManager != null) {
            this.planCacheManager.invalidateAll();
        }
    }

    public boolean isStatementSetState() {
        return this.isStatementSetState;
    }

    public void enableStatementSet() {
        this.isStatementSetState = true;
    }

    public void disableStatementSet() {
        this.isStatementSetState = false;
        this.statementSetOperations.clear();
    }

    public List<ModifyOperation> getStatementSetOperations() {
        return Collections.unmodifiableList(new ArrayList<ModifyOperation>(this.statementSetOperations));
    }

    public void addStatementSetOperation(ModifyOperation operation) {
        this.statementSetOperations.add(operation);
    }

    public void open() {
        try {
            this.sessionState.materializedTableManager.open();
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to open the materialized table manager for the session %s.", this.sessionId), (Throwable)e);
        }
    }

    public void close() {
        this.operationManager.close();
        try {
            this.sessionState.catalogManager.close();
        }
        catch (Throwable t) {
            LOG.error(String.format("Failed to close catalog manager for the session %s.", this.sessionId), t);
        }
        try {
            this.userClassloader.close();
        }
        catch (IOException e) {
            LOG.error(String.format("Error while closing class loader for the session %s.", this.sessionId), (Throwable)e);
        }
        try {
            this.sessionState.resourceManager.close();
        }
        catch (IOException e) {
            LOG.error(String.format("Failed to close the resource manager for the session %s.", this.sessionId), (Throwable)e);
        }
        try {
            this.sessionState.materializedTableManager.close();
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to close the materialized table manager for the session %s.", this.sessionId), (Throwable)e);
        }
    }

    public static SessionContext create(DefaultContext defaultContext, SessionHandle sessionId, SessionEnvironment environment, ExecutorService operationExecutorService) {
        Configuration configuration = SessionContext.initializeConfiguration(defaultContext, environment, sessionId);
        MutableURLClassLoader userClassLoader = FlinkUserCodeClassLoaders.create(defaultContext.getDependencies().toArray(new URL[0]), SessionContext.class.getClassLoader(), configuration);
        ResourceManager resourceManager = new ResourceManager(configuration, userClassLoader);
        return new SessionContext(defaultContext, sessionId, environment.getSessionEndpointVersion(), configuration, userClassLoader, SessionContext.initializeSessionState(environment, configuration, resourceManager), new OperationManager(operationExecutorService));
    }

    protected static Configuration initializeConfiguration(DefaultContext defaultContext, SessionEnvironment environment, SessionHandle sessionId) {
        Configuration configuration = defaultContext.getFlinkConfig().clone();
        configuration.addAll(Configuration.fromMap(environment.getSessionConfig()));
        Path path = Paths.get(configuration.get(TableConfigOptions.RESOURCES_DOWNLOAD_DIR), String.format("sql-gateway-%s", sessionId));
        configuration.set((ConfigOption)TableConfigOptions.RESOURCES_DOWNLOAD_DIR, path.toAbsolutePath().toString());
        return configuration;
    }

    protected static SessionState initializeSessionState(SessionEnvironment environment, Configuration configuration, ResourceManager resourceManager) {
        ModuleManager moduleManager = SessionContext.buildModuleManager(environment, configuration, resourceManager.getUserClassLoader());
        CatalogManager catalogManager = SessionContext.buildCatalogManager(configuration, resourceManager.getUserClassLoader(), environment);
        FunctionCatalog functionCatalog = new FunctionCatalog(configuration, resourceManager, catalogManager, moduleManager);
        MaterializedTableManager materializedTableManager = new MaterializedTableManager(configuration, resourceManager.getUserClassLoader());
        return new SessionState(catalogManager, moduleManager, resourceManager, functionCatalog, materializedTableManager);
    }

    private static ModuleManager buildModuleManager(SessionEnvironment environment, ReadableConfig readableConfig, ClassLoader classLoader) {
        ModuleManager moduleManager = new ModuleManager();
        environment.getRegisteredModuleCreators().forEach((moduleName, moduleCreator) -> {
            ArrayDeque<String> moduleNames = new ArrayDeque<String>(moduleManager.listModules());
            moduleNames.addFirst((String)moduleName);
            Module module = moduleCreator.create(readableConfig, classLoader);
            moduleManager.loadModule((String)moduleName, module);
            moduleManager.useModules(moduleNames.toArray(new String[0]));
        });
        return moduleManager;
    }

    private static CatalogManager buildCatalogManager(Configuration configuration, URLClassLoader userClassLoader, SessionEnvironment environment) {
        Catalog defaultCatalog;
        String defaultCatalogName;
        CatalogStoreFactory catalogStoreFactory = TableFactoryUtil.findAndCreateCatalogStoreFactory(configuration, userClassLoader);
        CatalogStoreFactory.Context catalogStoreFactoryContext = TableFactoryUtil.buildCatalogStoreFactoryContext(configuration, userClassLoader);
        catalogStoreFactory.open(catalogStoreFactoryContext);
        CatalogStoreHolder catalogStore = CatalogStoreHolder.newBuilder().catalogStore(catalogStoreFactory.createCatalogStore()).classloader(userClassLoader).config(configuration).factory(catalogStoreFactory).build();
        CatalogManager.Builder builder = CatalogManager.newBuilder().classLoader(userClassLoader).config(configuration).catalogModificationListeners(TableFactoryUtil.findCatalogModificationListenerList(configuration, userClassLoader)).catalogStoreHolder(catalogStore);
        if (environment.getDefaultCatalog().isPresent()) {
            defaultCatalogName = environment.getDefaultCatalog().get();
            defaultCatalog = environment.getRegisteredCatalogCreators().get(defaultCatalogName).create(configuration, userClassLoader);
        } else {
            EnvironmentSettings settings = EnvironmentSettings.newInstance().withConfiguration(configuration).build();
            defaultCatalogName = settings.getBuiltInCatalogName();
            if (environment.getRegisteredCatalogCreators().containsKey(defaultCatalogName)) {
                throw new SqlGatewayException(String.format("The name of the registered catalog is conflicts with the built-in default catalog name: %s.", defaultCatalogName));
            }
            defaultCatalog = catalogStore.catalogStore().getCatalog(defaultCatalogName).map(catalogDescriptor -> FactoryUtil.createCatalog(defaultCatalogName, catalogDescriptor.getConfiguration().toMap(), catalogStore.config(), catalogStore.classLoader())).orElse(new EnvironmentReusableInMemoryCatalog(defaultCatalogName, settings.getBuiltInDatabaseName()));
        }
        defaultCatalog.open();
        CatalogManager catalogManager = builder.defaultCatalog(defaultCatalogName, defaultCatalog).build();
        environment.getRegisteredCatalogCreators().forEach((catalogName, catalogCreator) -> {
            if (!catalogName.equals(defaultCatalogName)) {
                catalogManager.registerCatalog((String)catalogName, catalogCreator.create(configuration, userClassLoader));
            }
        });
        return catalogManager;
    }

    public static class SessionState {
        public final CatalogManager catalogManager;
        public final ResourceManager resourceManager;
        public final FunctionCatalog functionCatalog;
        public final ModuleManager moduleManager;
        public final MaterializedTableManager materializedTableManager;

        public SessionState(CatalogManager catalogManager, ModuleManager moduleManager, ResourceManager resourceManager, FunctionCatalog functionCatalog, MaterializedTableManager materializedTableManager) {
            this.catalogManager = catalogManager;
            this.moduleManager = moduleManager;
            this.resourceManager = resourceManager;
            this.functionCatalog = functionCatalog;
            this.materializedTableManager = materializedTableManager;
        }
    }
}

