/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;

@PublicEvolving
public final class LatencyMarker
extends StreamElement {
    private final long markedTime;
    private final OperatorID operatorId;
    private final int subtaskIndex;

    public LatencyMarker(long markedTime, OperatorID operatorId, int subtaskIndex) {
        this.markedTime = markedTime;
        this.operatorId = operatorId;
        this.subtaskIndex = subtaskIndex;
    }

    public long getMarkedTime() {
        return this.markedTime;
    }

    public OperatorID getOperatorId() {
        return this.operatorId;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatencyMarker that = (LatencyMarker)o;
        if (this.markedTime != that.markedTime) {
            return false;
        }
        if (!this.operatorId.equals(that.operatorId)) {
            return false;
        }
        return this.subtaskIndex == that.subtaskIndex;
    }

    public int hashCode() {
        int result = (int)(this.markedTime ^ this.markedTime >>> 32);
        result = 31 * result + this.operatorId.hashCode();
        result = 31 * result + this.subtaskIndex;
        return result;
    }

    public String toString() {
        return "LatencyMarker{markedTime=" + this.markedTime + ", operatorId=" + this.operatorId + ", subtaskIndex=" + this.subtaskIndex + "}";
    }
}

