/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.streaming.api.functions.sink.legacy.OutputFormatSinkFunction;
import org.apache.flink.streaming.api.functions.source.legacy.InputFormatSourceFunction;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.OperatorAttributes;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.operators.SimpleInputFormatOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleOutputFormatOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleUdfStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.operators.UserFunctionProvider;
import org.apache.flink.util.Preconditions;

@Internal
public class SimpleOperatorFactory<OUT>
extends AbstractStreamOperatorFactory<OUT> {
    private final StreamOperator<OUT> operator;

    public static <OUT> SimpleOperatorFactory<OUT> of(StreamOperator<OUT> operator) {
        if (operator == null) {
            return null;
        }
        if (operator instanceof StreamSource && ((StreamSource)operator).getUserFunction() instanceof InputFormatSourceFunction) {
            return new SimpleInputFormatOperatorFactory((StreamSource)operator);
        }
        if (operator instanceof UserFunctionProvider && ((UserFunctionProvider)((Object)operator)).getUserFunction() instanceof OutputFormatSinkFunction) {
            return new SimpleOutputFormatOperatorFactory(((OutputFormatSinkFunction)((UserFunctionProvider)((Object)operator)).getUserFunction()).getFormat(), operator);
        }
        if (operator instanceof AbstractUdfStreamOperator) {
            return new SimpleUdfStreamOperatorFactory((AbstractUdfStreamOperator)operator);
        }
        return new SimpleOperatorFactory<OUT>(operator);
    }

    protected SimpleOperatorFactory(StreamOperator<OUT> operator) {
        this.operator = Preconditions.checkNotNull(operator);
    }

    public StreamOperator<OUT> getOperator() {
        return this.operator;
    }

    @Override
    public <T extends StreamOperator<OUT>> T createStreamOperator(StreamOperatorParameters<OUT> parameters) {
        if (this.operator instanceof AbstractStreamOperator) {
            ((AbstractStreamOperator)this.operator).setProcessingTimeService(parameters.getProcessingTimeService());
            ((AbstractStreamOperator)this.operator).setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        }
        return (T)this.operator;
    }

    @Override
    public boolean isStreamSource() {
        return this.operator instanceof StreamSource;
    }

    @Override
    public boolean isLegacySource() {
        return this.operator instanceof StreamSource;
    }

    @Override
    public boolean isOutputTypeConfigurable() {
        return this.operator instanceof OutputTypeConfigurable;
    }

    @Override
    public void setOutputType(TypeInformation<OUT> type, ExecutionConfig executionConfig) {
        ((OutputTypeConfigurable)((Object)this.operator)).setOutputType(type, executionConfig);
    }

    @Override
    public boolean isInputTypeConfigurable() {
        return this.operator instanceof InputTypeConfigurable;
    }

    @Override
    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        ((InputTypeConfigurable)((Object)this.operator)).setInputType(type, executionConfig);
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return this.operator.getClass();
    }

    @Override
    public OperatorAttributes getOperatorAttributes() {
        return this.operator.getOperatorAttributes();
    }
}

