/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Collection;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;
import org.apache.flink.runtime.scheduler.VertexParallelismStore;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;
import org.apache.flink.shaded.guava32.com.google.common.collect.Iterables;
import org.apache.flink.util.InstantiationUtil;

public class JobGraphJobInformation
implements JobInformation {
    private final JobGraph jobGraph;
    private final JobID jobID;
    private final String name;
    private final VertexParallelismStore vertexParallelismStore;

    public JobGraphJobInformation(JobGraph jobGraph, VertexParallelismStore vertexParallelismStore) {
        this.jobGraph = jobGraph;
        this.jobID = jobGraph.getJobID();
        this.name = jobGraph.getName();
        this.vertexParallelismStore = vertexParallelismStore;
    }

    @Override
    public Collection<SlotSharingGroup> getSlotSharingGroups() {
        return this.jobGraph.getSlotSharingGroups();
    }

    @Override
    public JobInformation.VertexInformation getVertexInformation(JobVertexID jobVertexId) {
        return new JobVertexInformation(this.jobGraph.findVertexByID(jobVertexId), this.vertexParallelismStore.getParallelismInfo(jobVertexId));
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public String getName() {
        return this.name;
    }

    public JobCheckpointingSettings getCheckpointingSettings() {
        return this.jobGraph.getCheckpointingSettings();
    }

    @Override
    public Iterable<JobInformation.VertexInformation> getVertices() {
        return Iterables.transform(this.jobGraph.getVertices(), vertex -> this.getVertexInformation(vertex.getID()));
    }

    public JobGraph copyJobGraph() {
        return InstantiationUtil.cloneUnchecked(this.jobGraph);
    }

    public VertexParallelismStore getVertexParallelismStore() {
        return this.vertexParallelismStore;
    }

    private static final class JobVertexInformation
    implements JobInformation.VertexInformation {
        private final JobVertex jobVertex;
        private final VertexParallelismInformation parallelismInfo;

        private JobVertexInformation(JobVertex jobVertex, VertexParallelismInformation parallelismInfo) {
            this.jobVertex = jobVertex;
            this.parallelismInfo = parallelismInfo;
        }

        @Override
        public JobVertexID getJobVertexID() {
            return this.jobVertex.getID();
        }

        @Override
        public int getMinParallelism() {
            return this.parallelismInfo.getMinParallelism();
        }

        @Override
        public int getParallelism() {
            return this.parallelismInfo.getParallelism();
        }

        @Override
        public int getMaxParallelism() {
            return this.parallelismInfo.getMaxParallelism();
        }

        @Override
        public SlotSharingGroup getSlotSharingGroup() {
            return this.jobVertex.getSlotSharingGroup();
        }
    }
}

