/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.handler.async.CompletedOperationCache;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.concurrent.FutureUtils;

public class DispatcherOperationCaches
implements AutoCloseableAsync {
    private final CompletedOperationCache<AsynchronousJobOperationKey, String> savepointTriggerCache;
    private final CompletedOperationCache<AsynchronousJobOperationKey, Long> checkpointTriggerCache;

    @VisibleForTesting
    public DispatcherOperationCaches() {
        this(RestOptions.ASYNC_OPERATION_STORE_DURATION.defaultValue());
    }

    @VisibleForTesting
    public DispatcherOperationCaches(Duration cacheDuration) {
        this.savepointTriggerCache = new CompletedOperationCache(cacheDuration);
        this.checkpointTriggerCache = new CompletedOperationCache(cacheDuration);
    }

    public CompletedOperationCache<AsynchronousJobOperationKey, String> getSavepointTriggerCache() {
        return this.savepointTriggerCache;
    }

    public CompletedOperationCache<AsynchronousJobOperationKey, Long> getCheckpointTriggerCache() {
        return this.checkpointTriggerCache;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return FutureUtils.completeAll(Arrays.asList(this.savepointTriggerCache.closeAsync(), this.checkpointTriggerCache.closeAsync()));
    }
}

