/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class OperatorState
implements CompositeStateHandle {
    private static final long serialVersionUID = -4845578005863201810L;
    @Nullable
    private String operatorName;
    @Nullable
    private String operatorUid;
    private final OperatorID operatorID;
    private final Map<Integer, OperatorSubtaskState> operatorSubtaskStates;
    @Nullable
    private ByteStreamStateHandle coordinatorState;
    private final int parallelism;
    private final int maxParallelism;

    public OperatorState(@Nullable String operatorName, @Nullable String operatorUid, OperatorID operatorID, int parallelism, int maxParallelism) {
        if (parallelism > maxParallelism) {
            throw new IllegalArgumentException(String.format("Parallelism %s is not smaller or equal to max parallelism %s.", parallelism, maxParallelism));
        }
        this.operatorName = operatorName;
        this.operatorUid = operatorUid;
        this.operatorID = operatorID;
        this.operatorSubtaskStates = CollectionUtil.newHashMapWithExpectedSize(parallelism);
        this.parallelism = parallelism;
        this.maxParallelism = maxParallelism;
    }

    public Optional<String> getOperatorName() {
        return Optional.ofNullable(this.operatorName);
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Optional<String> getOperatorUid() {
        return Optional.ofNullable(this.operatorUid);
    }

    public void setOperatorUid(String operatorUid) {
        this.operatorUid = operatorUid;
    }

    public OperatorID getOperatorID() {
        return this.operatorID;
    }

    public boolean isFullyFinished() {
        return false;
    }

    public void putState(int subtaskIndex, OperatorSubtaskState subtaskState) {
        Preconditions.checkNotNull(subtaskState);
        if (subtaskIndex < 0 || subtaskIndex >= this.parallelism) {
            throw new IndexOutOfBoundsException("The given sub task index " + subtaskIndex + " exceeds the maximum number of sub tasks " + this.operatorSubtaskStates.size());
        }
        this.operatorSubtaskStates.put(subtaskIndex, subtaskState);
    }

    public OperatorSubtaskState getState(int subtaskIndex) {
        if (subtaskIndex < 0 || subtaskIndex >= this.parallelism) {
            throw new IndexOutOfBoundsException("The given sub task index " + subtaskIndex + " exceeds the maximum number of sub tasks " + this.operatorSubtaskStates.size());
        }
        return this.operatorSubtaskStates.get(subtaskIndex);
    }

    public void setCoordinatorState(@Nullable ByteStreamStateHandle coordinatorState) {
        Preconditions.checkState(this.coordinatorState == null, "coordinator state already set");
        this.coordinatorState = coordinatorState;
    }

    @Nullable
    public ByteStreamStateHandle getCoordinatorState() {
        return this.coordinatorState;
    }

    public Map<Integer, OperatorSubtaskState> getSubtaskStates() {
        return Collections.unmodifiableMap(this.operatorSubtaskStates);
    }

    public Collection<OperatorSubtaskState> getStates() {
        return this.operatorSubtaskStates.values();
    }

    public int getNumberCollectedStates() {
        return this.operatorSubtaskStates.size();
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public OperatorState copyWithNewIDs(@Nullable String newOperatorUid, OperatorID newOperatorId) {
        OperatorState newState = new OperatorState(this.operatorName, newOperatorUid, newOperatorId, this.parallelism, this.maxParallelism);
        this.operatorSubtaskStates.forEach(newState::putState);
        return newState;
    }

    public OperatorState copyAndDiscardInFlightData() {
        OperatorState newState = new OperatorState(this.operatorName, this.operatorUid, this.operatorID, this.parallelism, this.maxParallelism);
        for (Map.Entry<Integer, OperatorSubtaskState> originalSubtaskStateEntry : this.operatorSubtaskStates.entrySet()) {
            newState.putState(originalSubtaskStateEntry.getKey(), originalSubtaskStateEntry.getValue().toBuilder().setResultSubpartitionState(StateObjectCollection.empty()).setInputChannelState(StateObjectCollection.empty()).build());
        }
        return newState;
    }

    public List<StateObject> getDiscardables() {
        List<StateObject> toDispose = this.operatorSubtaskStates.values().stream().flatMap(op -> op.getDiscardables().stream()).collect(Collectors.toList());
        if (this.coordinatorState != null) {
            toDispose.add(this.coordinatorState);
        }
        return toDispose;
    }

    @Override
    public void discardState() throws Exception {
        for (OperatorSubtaskState operatorSubtaskState : this.operatorSubtaskStates.values()) {
            operatorSubtaskState.discardState();
        }
        if (this.coordinatorState != null) {
            this.coordinatorState.discardState();
        }
    }

    @Override
    public void registerSharedStates(SharedStateRegistry sharedStateRegistry, long checkpointID) {
        for (OperatorSubtaskState operatorSubtaskState : this.operatorSubtaskStates.values()) {
            operatorSubtaskState.registerSharedStates(sharedStateRegistry, checkpointID);
        }
    }

    public boolean hasSubtaskStates() {
        return this.operatorSubtaskStates.size() > 0;
    }

    @Override
    public long getStateSize() {
        return this.streamAllSubHandles().mapToLong(StateObject::getStateSize).sum();
    }

    @Override
    public void collectSizeStats(StateObject.StateObjectSizeStatsCollector collector) {
        this.streamAllSubHandles().forEach(handle -> handle.collectSizeStats(collector));
    }

    private Stream<StateObject> streamAllSubHandles() {
        return Stream.concat(Stream.of(this.coordinatorState), this.operatorSubtaskStates.values().stream()).filter(Objects::nonNull);
    }

    @Override
    public long getCheckpointedSize() {
        long result = this.coordinatorState == null ? 0L : this.coordinatorState.getStateSize();
        for (int i = 0; i < this.parallelism; ++i) {
            OperatorSubtaskState operatorSubtaskState = this.operatorSubtaskStates.get(i);
            if (operatorSubtaskState == null) continue;
            result += operatorSubtaskState.getCheckpointedSize();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OperatorState) {
            OperatorState other = (OperatorState)obj;
            return this.operatorID.equals(other.operatorID) && this.parallelism == other.parallelism && Objects.equals(this.coordinatorState, other.coordinatorState) && this.operatorSubtaskStates.equals(other.operatorSubtaskStates);
        }
        return false;
    }

    public int hashCode() {
        return this.parallelism + 31 * Objects.hash(this.operatorID, this.operatorSubtaskStates);
    }

    public String toString() {
        return "OperatorState(name: " + this.getOperatorName() + ", uid: " + this.getOperatorUid() + ", operatorID: " + this.operatorID + ", parallelism: " + this.parallelism + ", maxParallelism: " + this.maxParallelism + ", coordinatorState: " + (String)(this.coordinatorState == null ? "(none)" : this.coordinatorState.getStateSize() + " bytes") + ", sub task states: " + this.operatorSubtaskStates.size() + ", total size (bytes): " + this.getStateSize() + ")";
    }
}

