/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.core.execution.RecoveryClaimMode;

@PublicEvolving
public class StateRecoveryOptions {
    public static final ConfigOption<String> SAVEPOINT_PATH = ConfigOptions.key("execution.state-recovery.path").stringType().noDefaultValue().withDeprecatedKeys("execution.savepoint.path").withDescription("Path to a savepoint to restore the job from (for example hdfs:///flink/savepoint-1537).");
    public static final ConfigOption<Boolean> SAVEPOINT_IGNORE_UNCLAIMED_STATE = ConfigOptions.key("execution.state-recovery.ignore-unclaimed-state").booleanType().defaultValue(false).withDeprecatedKeys("execution.savepoint.ignore-unclaimed-state").withDescription("Allow to skip savepoint state that cannot be restored. Allow this if you removed an operator from your pipeline after the savepoint was triggered.");
    public static final ConfigOption<RecoveryClaimMode> RESTORE_MODE = ConfigOptions.key("execution.state-recovery.claim-mode").enumType(RecoveryClaimMode.class).defaultValue(RecoveryClaimMode.DEFAULT).withDeprecatedKeys("execution.savepoint-restore-mode").withDescription("Describes the mode how Flink should restore from the given savepoint or retained checkpoint.");
    @Documentation.ExcludeFromDocumentation
    @Internal
    public static final ConfigOption<Boolean> APPROXIMATE_LOCAL_RECOVERY = ConfigOptions.key("execution.state-recovery.approximate-local-recovery").booleanType().defaultValue(false).withDeprecatedKeys("execution.checkpointing.approximate-local-recovery").withDescription("Flag to enable approximate local recovery.");
    public static final ConfigOption<Long> CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA = ConfigOptions.key("execution.state-recovery.without-channel-state.checkpoint-id").longType().defaultValue(-1L).withDeprecatedKeys("execution.checkpointing.recover-without-channel-state.checkpoint-id").withDescription(Description.builder().text("Checkpoint id for which in-flight data should be ignored in case of the recovery from this checkpoint.").linebreak().linebreak().text("It is better to keep this value empty until there is explicit needs to restore from the specific checkpoint without in-flight data.").linebreak().build());
    public static final ConfigOption<Boolean> LOCAL_RECOVERY = ConfigOptions.key("execution.state-recovery.from-local").booleanType().defaultValue(false).withDeprecatedKeys("state.backend.local-recovery").withDescription("This option configures local recovery for the state backend, which indicates whether to recovery from local snapshot.By default, local recovery is deactivated. Local recovery currently only covers keyed state backends (including both the EmbeddedRocksDBStateBackend and the HashMapStateBackend).\"");
}

