/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.net.InetAddress;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.TaskManagerOptionsInternal;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.entrypoint.WorkingDirectory;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.runtime.taskexecutor.QueryableStateConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.util.ConfigurationParserUtils;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Reference;

public class TaskManagerServicesConfiguration {
    private static final String LOCAL_STATE_SUB_DIRECTORY_ROOT = "localState_";
    private final Configuration configuration;
    private final ResourceID resourceID;
    private final String externalAddress;
    private final String nodeId;
    private final InetAddress bindAddress;
    private final int externalDataPort;
    private final boolean localCommunicationOnly;
    private final String[] tmpDirPaths;
    private final Reference<File[]> localRecoveryStateDirectories;
    private final int numberOfSlots;
    @Nullable
    private final QueryableStateConfiguration queryableStateConfig;
    private final int pageSize;
    private final long timerServiceShutdownTimeout;
    private final boolean localRecoveryEnabled;
    private final boolean localBackupEnabled;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;
    private Optional<Time> systemResourceMetricsProbingInterval;
    private final TaskExecutorResourceSpec taskExecutorResourceSpec;
    private final FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder;
    private final String[] alwaysParentFirstLoaderPatterns;
    private final int numIoThreads;

    private TaskManagerServicesConfiguration(Configuration configuration, ResourceID resourceID, String externalAddress, InetAddress bindAddress, int externalDataPort, boolean localCommunicationOnly, String[] tmpDirPaths, Reference<File[]> localRecoveryStateDirectories, boolean localRecoveryEnabled, boolean localBackupEnabled, @Nullable QueryableStateConfiguration queryableStateConfig, int numberOfSlots, int pageSize, TaskExecutorResourceSpec taskExecutorResourceSpec, long timerServiceShutdownTimeout, RetryingRegistrationConfiguration retryingRegistrationConfiguration, Optional<Time> systemResourceMetricsProbingInterval, FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder, String[] alwaysParentFirstLoaderPatterns, int numIoThreads, String nodeId) {
        this.configuration = Preconditions.checkNotNull(configuration);
        this.resourceID = Preconditions.checkNotNull(resourceID);
        this.externalAddress = Preconditions.checkNotNull(externalAddress);
        this.bindAddress = Preconditions.checkNotNull(bindAddress);
        this.externalDataPort = externalDataPort;
        this.localCommunicationOnly = localCommunicationOnly;
        this.tmpDirPaths = Preconditions.checkNotNull(tmpDirPaths);
        this.localRecoveryStateDirectories = Preconditions.checkNotNull(localRecoveryStateDirectories);
        this.localRecoveryEnabled = localRecoveryEnabled;
        this.localBackupEnabled = localBackupEnabled;
        this.queryableStateConfig = queryableStateConfig;
        this.numberOfSlots = numberOfSlots;
        this.pageSize = pageSize;
        this.taskExecutorResourceSpec = taskExecutorResourceSpec;
        this.classLoaderResolveOrder = classLoaderResolveOrder;
        this.alwaysParentFirstLoaderPatterns = alwaysParentFirstLoaderPatterns;
        this.numIoThreads = numIoThreads;
        Preconditions.checkArgument(timerServiceShutdownTimeout >= 0L, "The timer service shutdown timeout must be greater or equal to 0.");
        this.timerServiceShutdownTimeout = timerServiceShutdownTimeout;
        this.retryingRegistrationConfiguration = Preconditions.checkNotNull(retryingRegistrationConfiguration);
        this.systemResourceMetricsProbingInterval = Preconditions.checkNotNull(systemResourceMetricsProbingInterval);
        this.nodeId = Preconditions.checkNotNull(nodeId);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    String getExternalAddress() {
        return this.externalAddress;
    }

    InetAddress getBindAddress() {
        return this.bindAddress;
    }

    int getExternalDataPort() {
        return this.externalDataPort;
    }

    boolean isLocalCommunicationOnly() {
        return this.localCommunicationOnly;
    }

    public String[] getTmpDirPaths() {
        return this.tmpDirPaths;
    }

    Reference<File[]> getLocalRecoveryStateDirectories() {
        return this.localRecoveryStateDirectories;
    }

    boolean isLocalRecoveryEnabled() {
        return this.localRecoveryEnabled;
    }

    boolean isLocalBackupEnabled() {
        return this.localBackupEnabled;
    }

    @Nullable
    QueryableStateConfiguration getQueryableStateConfig() {
        return this.queryableStateConfig;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public TaskExecutorResourceSpec getTaskExecutorResourceSpec() {
        return this.taskExecutorResourceSpec;
    }

    public MemorySize getNetworkMemorySize() {
        return this.taskExecutorResourceSpec.getNetworkMemSize();
    }

    public MemorySize getManagedMemorySize() {
        return this.taskExecutorResourceSpec.getManagedMemorySize();
    }

    long getTimerServiceShutdownTimeout() {
        return this.timerServiceShutdownTimeout;
    }

    public Optional<Time> getSystemResourceMetricsProbingInterval() {
        return this.systemResourceMetricsProbingInterval;
    }

    RetryingRegistrationConfiguration getRetryingRegistrationConfiguration() {
        return this.retryingRegistrationConfiguration;
    }

    public FlinkUserCodeClassLoaders.ResolveOrder getClassLoaderResolveOrder() {
        return this.classLoaderResolveOrder;
    }

    public String[] getAlwaysParentFirstLoaderPatterns() {
        return this.alwaysParentFirstLoaderPatterns;
    }

    public int getNumIoThreads() {
        return this.numIoThreads;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public static TaskManagerServicesConfiguration fromConfiguration(Configuration configuration, ResourceID resourceID, String externalAddress, boolean localCommunicationOnly, TaskExecutorResourceSpec taskExecutorResourceSpec, WorkingDirectory workingDirectory) throws Exception {
        Reference<File[]> localStateDirs;
        String[] localStateRootDirs = ConfigurationUtils.parseLocalStateDirectories(configuration);
        if (localStateRootDirs.length == 0) {
            localStateDirs = Reference.borrowed(new File[]{workingDirectory.getLocalStateDirectory()});
        } else {
            File[] createdLocalStateDirs = new File[localStateRootDirs.length];
            String localStateDirectoryName = LOCAL_STATE_SUB_DIRECTORY_ROOT + resourceID;
            for (int i = 0; i < localStateRootDirs.length; ++i) {
                createdLocalStateDirs[i] = new File(localStateRootDirs[i], localStateDirectoryName);
            }
            localStateDirs = Reference.owned(createdLocalStateDirs);
        }
        boolean localRecoveryEnabled = configuration.get(StateRecoveryOptions.LOCAL_RECOVERY);
        boolean localBackupEnabled = configuration.get(CheckpointingOptions.LOCAL_BACKUP_ENABLED);
        QueryableStateConfiguration queryableStateConfig = QueryableStateConfiguration.fromConfiguration(configuration);
        long timerServiceShutdownTimeout = configuration.get(RpcOptions.ASK_TIMEOUT_DURATION).toMillis();
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration(configuration);
        int externalDataPort = configuration.get(NettyShuffleEnvironmentOptions.DATA_PORT);
        String bindAddr = configuration.get(TaskManagerOptions.BIND_HOST, NetUtils.getWildcardIPAddress());
        InetAddress bindAddress = InetAddress.getByName(bindAddr);
        String classLoaderResolveOrder = configuration.get(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns(configuration);
        int numIoThreads = ClusterEntrypointUtils.getPoolSize(configuration);
        String[] tmpDirs = ConfigurationUtils.parseTempDirectories(configuration);
        String nodeId = configuration.getOptional(TaskManagerOptionsInternal.TASK_MANAGER_NODE_ID).orElse(externalAddress);
        return new TaskManagerServicesConfiguration(configuration, resourceID, externalAddress, bindAddress, externalDataPort, localCommunicationOnly, tmpDirs, localStateDirs, localRecoveryEnabled, localBackupEnabled, queryableStateConfig, ConfigurationParserUtils.getSlot(configuration), ConfigurationParserUtils.getPageSize(configuration), taskExecutorResourceSpec, timerServiceShutdownTimeout, retryingRegistrationConfiguration, ConfigurationUtils.getSystemResourceMetricsProbingInterval(configuration), FlinkUserCodeClassLoaders.ResolveOrder.fromString(classLoaderResolveOrder), alwaysParentFirstLoaderPatterns, numIoThreads, nodeId);
    }
}

