/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.util.Preconditions;

public class ExecutionVertexInputInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int subtaskIndex;
    private final IndexRange partitionIndexRange;
    private final IndexRange subpartitionIndexRange;

    public ExecutionVertexInputInfo(int subtaskIndex, IndexRange partitionIndexRange, IndexRange subpartitionIndexRange) {
        this.subtaskIndex = subtaskIndex;
        this.partitionIndexRange = Preconditions.checkNotNull(partitionIndexRange);
        this.subpartitionIndexRange = Preconditions.checkNotNull(subpartitionIndexRange);
    }

    public IndexRange getSubpartitionIndexRange() {
        return this.subpartitionIndexRange;
    }

    public IndexRange getPartitionIndexRange() {
        return this.partitionIndexRange;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ExecutionVertexInputInfo that = (ExecutionVertexInputInfo)obj;
            return that.subtaskIndex == this.subtaskIndex && that.partitionIndexRange.equals(this.partitionIndexRange) && that.subpartitionIndexRange.equals(this.subpartitionIndexRange);
        }
        return false;
    }
}

