/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartAllFailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartPipelinedRegionFailoverStrategy;
import org.apache.flink.util.Preconditions;

public final class FailoverStrategyFactoryLoader {
    public static final String FULL_RESTART_STRATEGY_NAME = "full";
    public static final String PIPELINED_REGION_RESTART_STRATEGY_NAME = "region";

    private FailoverStrategyFactoryLoader() {
    }

    public static FailoverStrategy.Factory loadFailoverStrategyFactory(Configuration config) {
        Preconditions.checkNotNull(config);
        String strategyParam = config.get(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY);
        switch (strategyParam.toLowerCase()) {
            case "full": {
                return new RestartAllFailoverStrategy.Factory();
            }
            case "region": {
                return new RestartPipelinedRegionFailoverStrategy.Factory();
            }
        }
        throw new IllegalConfigurationException("Unknown failover strategy: " + strategyParam);
    }
}

