/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.Archiveable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionHistory;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertexInputInfo;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.InternalExecutionGraphAccessor;
import org.apache.flink.runtime.executiongraph.MarkPartitionFinishedStrategy;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class ExecutionVertex
implements AccessExecutionVertex,
Archiveable<ArchivedExecutionVertex> {
    public static final long NUM_BYTES_UNKNOWN = -1L;
    final ExecutionJobVertex jobVertex;
    private final Map<IntermediateResultPartitionID, IntermediateResultPartition> resultPartitions;
    private final int subTaskIndex;
    private final ExecutionVertexID executionVertexId;
    final ExecutionHistory executionHistory;
    private final Time timeout;
    private final String taskNameWithSubtask;
    Execution currentExecution;
    final ArrayList<InputSplit> inputSplits;
    private int nextAttemptNumber;
    private long inputBytes;
    @Nullable
    private TaskManagerLocation lastAssignedLocation;
    @Nullable
    private AllocationID lastAssignedAllocationID;

    @VisibleForTesting
    public ExecutionVertex(ExecutionJobVertex jobVertex, int subTaskIndex, IntermediateResult[] producedDataSets, Time timeout, long createTimestamp, int executionHistorySizeLimit, int initialAttemptCount) {
        this.jobVertex = jobVertex;
        this.subTaskIndex = subTaskIndex;
        this.executionVertexId = new ExecutionVertexID(jobVertex.getJobVertexId(), subTaskIndex);
        this.taskNameWithSubtask = String.format("%s (%d/%d)", jobVertex.getJobVertex().getName(), subTaskIndex + 1, jobVertex.getParallelism());
        this.resultPartitions = new LinkedHashMap<IntermediateResultPartitionID, IntermediateResultPartition>(producedDataSets.length, 1.0f);
        for (IntermediateResult result : producedDataSets) {
            IntermediateResultPartition irp = new IntermediateResultPartition(result, this, subTaskIndex, this.getExecutionGraphAccessor().getEdgeManager());
            result.setPartition(subTaskIndex, irp);
            this.resultPartitions.put(irp.getPartitionId(), irp);
        }
        this.executionHistory = new ExecutionHistory(executionHistorySizeLimit);
        this.nextAttemptNumber = initialAttemptCount;
        this.inputBytes = -1L;
        this.timeout = timeout;
        this.inputSplits = new ArrayList();
        this.currentExecution = this.createNewExecution(createTimestamp);
        this.getExecutionGraphAccessor().registerExecution(this.currentExecution);
    }

    Execution createNewExecution(long timestamp) {
        return new Execution(this.getExecutionGraphAccessor().getFutureExecutor(), this, this.nextAttemptNumber++, timestamp, this.timeout);
    }

    public ExecutionVertexInputInfo getExecutionVertexInputInfo(IntermediateDataSetID resultId) {
        return this.getExecutionGraphAccessor().getJobVertexInputInfo(this.getJobvertexId(), resultId).getExecutionVertexInputInfos().get(this.subTaskIndex);
    }

    public void setInputBytes(long inputBytes) {
        this.inputBytes = inputBytes;
    }

    public long getInputBytes() {
        return this.inputBytes;
    }

    public Execution getPartitionProducer() {
        return this.currentExecution;
    }

    public JobID getJobId() {
        return this.jobVertex.getJobId();
    }

    public ExecutionJobVertex getJobVertex() {
        return this.jobVertex;
    }

    public JobVertexID getJobvertexId() {
        return this.jobVertex.getJobVertexId();
    }

    public String getTaskName() {
        return this.jobVertex.getJobVertex().getName();
    }

    @Override
    public String getTaskNameWithSubtaskIndex() {
        return this.taskNameWithSubtask;
    }

    public int getTotalNumberOfParallelSubtasks() {
        return this.jobVertex.getParallelism();
    }

    public int getMaxParallelism() {
        return this.jobVertex.getMaxParallelism();
    }

    public ResourceProfile getResourceProfile() {
        return this.jobVertex.getResourceProfile();
    }

    @Override
    public int getParallelSubtaskIndex() {
        return this.subTaskIndex;
    }

    public ExecutionVertexID getID() {
        return this.executionVertexId;
    }

    public int getNumberOfInputs() {
        return this.getAllConsumedPartitionGroups().size();
    }

    public List<ConsumedPartitionGroup> getAllConsumedPartitionGroups() {
        return this.getExecutionGraphAccessor().getEdgeManager().getConsumedPartitionGroupsForVertex(this.executionVertexId);
    }

    public ConsumedPartitionGroup getConsumedPartitionGroup(int input) {
        List<ConsumedPartitionGroup> allConsumedPartitions = this.getAllConsumedPartitionGroups();
        if (input < 0 || input >= allConsumedPartitions.size()) {
            throw new IllegalArgumentException(String.format("Input %d is out of range [0..%d)", input, allConsumedPartitions.size()));
        }
        return allConsumedPartitions.get(input);
    }

    public Optional<InputSplit> getNextInputSplit(String host, int attemptNumber) {
        int subtaskIndex = this.getParallelSubtaskIndex();
        InputSplit nextInputSplit = this.jobVertex.getSplitAssigner().getNextInputSplit(host, subtaskIndex);
        if (nextInputSplit != null) {
            this.inputSplits.add(nextInputSplit);
        }
        return Optional.ofNullable(nextInputSplit);
    }

    @Override
    public Execution getCurrentExecutionAttempt() {
        return this.currentExecution;
    }

    public Collection<Execution> getCurrentExecutions() {
        return Collections.singleton(this.currentExecution);
    }

    public Execution getCurrentExecution(int attemptNumber) {
        Preconditions.checkArgument(attemptNumber == this.currentExecution.getAttemptNumber());
        return this.currentExecution;
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.getCurrentExecutionAttempt().getState();
    }

    @Override
    public long getStateTimestamp(ExecutionState state) {
        return this.getCurrentExecutionAttempt().getStateTimestamp(state);
    }

    @Override
    public Optional<ErrorInfo> getFailureInfo() {
        return this.getCurrentExecutionAttempt().getFailureInfo();
    }

    public CompletableFuture<TaskManagerLocation> getCurrentTaskManagerLocationFuture() {
        return this.getCurrentExecutionAttempt().getTaskManagerLocationFuture();
    }

    public LogicalSlot getCurrentAssignedResource() {
        return this.getCurrentExecutionAttempt().getAssignedResource();
    }

    @Override
    public TaskManagerLocation getCurrentAssignedResourceLocation() {
        return this.getCurrentExecutionAttempt().getAssignedResourceLocation();
    }

    @Override
    public ExecutionHistory getExecutionHistory() {
        return this.executionHistory;
    }

    void setLatestPriorSlotAllocation(TaskManagerLocation taskManagerLocation, AllocationID lastAssignedAllocationID) {
        this.lastAssignedLocation = Preconditions.checkNotNull(taskManagerLocation);
        this.lastAssignedAllocationID = Preconditions.checkNotNull(lastAssignedAllocationID);
    }

    public Optional<TaskManagerLocation> findLastLocation() {
        return Optional.ofNullable(this.lastAssignedLocation);
    }

    public Optional<AllocationID> findLastAllocation() {
        return Optional.ofNullable(this.lastAssignedAllocationID);
    }

    public final InternalExecutionGraphAccessor getExecutionGraphAccessor() {
        return this.jobVertex.getGraph();
    }

    public Map<IntermediateResultPartitionID, IntermediateResultPartition> getProducedPartitions() {
        return this.resultPartitions;
    }

    CompletableFuture<?> getTerminationFuture() {
        return this.currentExecution.getTerminalStateFuture();
    }

    public void addConsumedPartitionGroup(ConsumedPartitionGroup consumedPartitions) {
        this.getExecutionGraphAccessor().getEdgeManager().connectVertexWithConsumedPartitionGroup(this.executionVertexId, consumedPartitions);
    }

    public Optional<TaskManagerLocation> getPreferredLocationBasedOnState() {
        if (this.currentExecution.getTaskRestore() != null && this.currentExecution.getTaskRestore().getTaskStateSnapshot().hasState()) {
            return this.findLastLocation();
        }
        return Optional.empty();
    }

    public void resetForNewExecution() {
        this.resetForNewExecutionInternal(System.currentTimeMillis());
    }

    private void resetForNewExecutionInternal(long timestamp) {
        Execution newExecution;
        boolean isFinished = this.getExecutionState() == ExecutionState.FINISHED;
        this.resetExecutionsInternal();
        InputSplitAssigner assigner = this.jobVertex.getSplitAssigner();
        if (assigner != null) {
            assigner.returnInputSplit(this.inputSplits, this.getParallelSubtaskIndex());
            this.inputSplits.clear();
        }
        if (isFinished) {
            this.getJobVertex().executionVertexUnFinished();
        }
        for (IntermediateResultPartition resultPartition : this.resultPartitions.values()) {
            resultPartition.resetForNewExecution();
        }
        this.currentExecution = newExecution = this.createNewExecution(timestamp);
        this.getExecutionGraphAccessor().registerExecution(newExecution);
    }

    void resetExecutionsInternal() {
        this.resetExecution(this.currentExecution);
    }

    void resetExecution(Execution execution) {
        ExecutionState oldState = execution.getState();
        Preconditions.checkState(oldState.isTerminal(), "Cannot reset an execution that is in non-terminal state " + (Object)((Object)oldState));
        if (oldState == ExecutionState.FINISHED) {
            execution.handlePartitionCleanup(false, true);
            this.getExecutionGraphAccessor().getPartitionGroupReleaseStrategy().vertexUnfinished(this.executionVertexId);
        }
        this.executionHistory.add(execution.archive());
    }

    public void tryAssignResource(LogicalSlot slot) {
        if (!this.currentExecution.tryAssignResource(slot)) {
            throw new IllegalStateException("Could not assign resource " + slot + " to current execution " + this.currentExecution + '.');
        }
    }

    public void deploy() throws JobException {
        this.currentExecution.deploy();
    }

    @VisibleForTesting
    public void deployToSlot(LogicalSlot slot) throws JobException {
        if (!this.currentExecution.tryAssignResource(slot)) {
            throw new IllegalStateException("Could not assign resource " + slot + " to current execution " + this.currentExecution + '.');
        }
        this.currentExecution.deploy();
    }

    public CompletableFuture<?> cancel() {
        Execution exec = this.currentExecution;
        exec.cancel();
        return exec.getReleaseFuture();
    }

    public CompletableFuture<?> suspend() {
        return this.currentExecution.suspend();
    }

    public void fail(Throwable t) {
        this.currentExecution.fail(t);
    }

    public void markFailed(Throwable t) {
        this.currentExecution.markFailed(t);
    }

    void cachePartitionInfo(PartitionInfo partitionInfo) {
        this.getCurrentExecutionAttempt().cachePartitionInfo(partitionInfo);
    }

    @VisibleForTesting
    public List<IntermediateResultPartition> finishPartitionsIfNeeded() {
        LinkedList<IntermediateResultPartition> finishedPartitions = null;
        MarkPartitionFinishedStrategy markPartitionFinishedStrategy = this.getExecutionGraphAccessor().getMarkPartitionFinishedStrategy();
        for (IntermediateResultPartition partition : this.resultPartitions.values()) {
            if (!markPartitionFinishedStrategy.needMarkPartitionFinished(partition.getResultType())) continue;
            partition.markFinished();
            if (finishedPartitions == null) {
                finishedPartitions = new LinkedList<IntermediateResultPartition>();
            }
            finishedPartitions.add(partition);
        }
        if (finishedPartitions == null) {
            return Collections.emptyList();
        }
        return finishedPartitions;
    }

    void executionFinished(Execution execution) {
        this.getJobVertex().executionVertexFinished();
    }

    void notifyPendingDeployment(Execution execution) {
        if (this.isCurrentExecution(execution)) {
            this.getExecutionGraphAccessor().getExecutionDeploymentListener().onStartedDeployment(execution.getAttemptId(), execution.getAssignedResourceLocation().getResourceID());
        }
    }

    void notifyCompletedDeployment(Execution execution) {
        if (this.isCurrentExecution(execution)) {
            this.getExecutionGraphAccessor().getExecutionDeploymentListener().onCompletedDeployment(execution.getAttemptId());
        }
    }

    void notifyStateTransition(Execution execution, ExecutionState previousState, ExecutionState newState) {
        if (this.isCurrentExecution(execution)) {
            this.getExecutionGraphAccessor().notifyExecutionChange(execution, previousState, newState);
        }
    }

    private boolean isCurrentExecution(Execution execution) {
        return this.currentExecution == execution;
    }

    public String toString() {
        return this.getTaskNameWithSubtaskIndex();
    }

    @Override
    public ArchivedExecutionVertex archive() {
        return new ArchivedExecutionVertex(this);
    }
}

